package de.narimo.commons.dto;

public enum RegistrationLanguage {
    de_DE,
    en_GB,
    en_US,
    es_ES,
    fr_FR;

    public static RegistrationLanguage getRegistrationLanguage(String key) {

        try {
            RegistrationLanguage lang = RegistrationLanguage.valueOf(key);

            if (lang == null) {
                return RegistrationLanguage.en_US;
            }
            return lang;
        } catch (IllegalArgumentException | NullPointerException e) {
            return RegistrationLanguage.en_US;
        }
    }
}
