package de.narimo.commons.dto.xml.csw;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;

import de.narimo.commons.dto.xml.NodeElement;
import de.narimo.commons.dto.xml.ows.BoundingBox;

public class Record extends NodeElement {

	private String identifier;
	private String title;
	private List<String> type;
	private List<String> subject;
	private List<String> format;
	private List<String> references;
	private String description;
	private String publisher;
	private List<String> source;
	private List<String> rights;
	private String spatial;
	private BoundingBox boundingBox;

	@XmlElement(name="identifier", namespace="http://purl.org/dc/elements/1.1/")
	public String getIdentifier() {
		return this.identifier;
	}
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	@XmlElement(name="title", namespace="http://purl.org/dc/elements/1.1/")
	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	@XmlElement(name="type", namespace="http://purl.org/dc/elements/1.1/")
	public List<String> getType() {
		return this.type;
	}
	public void setType(List<String> type) {
		this.type = type;
	}

	@XmlElement(name="subject", namespace="http://purl.org/dc/elements/1.1/")
	public List<String> getSubject() {
		return this.subject;
	}
	public void setSubject(List<String> subject) {
		this.subject = subject;
	}

	@XmlElement(name="format", namespace="http://purl.org/dc/elements/1.1/")
	public List<String> getFormat() {
		return this.format;
	}
	public void setFormat(List<String> format) {
		this.format = format;
	}

	@XmlElement(name="references", namespace="http://purl.org/dc/terms/")
	public List<String> getReferences() {
		return this.references;
	}
	public void setReferences(List<String> references) {
		this.references = references;
	}

	@XmlElement(name="abstract", namespace="http://purl.org/dc/terms/")
	public String getDescription() {
		return this.description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	@XmlElement(name="publisher", namespace="http://purl.org/dc/elements/1.1/")
	public String getPublisher() {
		return this.publisher;
	}
	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	@XmlElement(name="source", namespace="http://purl.org/dc/elements/1.1/")
	public List<String> getSource() {
		return this.source;
	}
	public void setSource(List<String> source) {
		this.source = source;
	}

	@XmlElement(name="rights", namespace="http://purl.org/dc/elements/1.1/")
	public List<String> getRights() {
		return this.rights;
	}
	public void setRights(List<String> rights) {
		this.rights = rights;
	}

	@XmlElement(name="spatial", namespace="http://purl.org/dc/terms/")
	public String getSpatial() {
		return this.spatial;
	}
	public void setSpatial(String spatial) {
		this.spatial = spatial;
	}

	@XmlElement(name="BoundingBox", namespace="http://www.opengis.net/ows")
	public BoundingBox getBoundingBox() {
		return this.boundingBox;
	}
	public void setBoundingBox(BoundingBox boundingBox) {
		this.boundingBox = boundingBox;
	}
}
