<?xml version="1.0"?>
<!-- Import Qualitaetsberichte Krankenhaeuser 2015 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ext="http://exslt.org/common"
    extension-element-prefixes="ext" >
<xsl:output method="text" encoding="utf-8" />
<xsl:param name="quote" select="'&quot;'" />


<xsl:template match="/">
ID;Name;IKNr;Standortnummer;Strasse;Hausnr;PLZ;Ort;URL;Anzahl_Betten;Erstelldatum;Erstellzeit

<xsl:for-each select="Qualitaetsbericht">

   	<xsl:choose>
    	<xsl:when test="Einziger_Standort">		    	
			<xsl:for-each select="Krankenhaus">
			
<!-- 		<xsl:when test="not(Einziger_Standort) and Standort_dieses_Berichts">		    	 -->
<!-- 			<xsl:for-each select="Standort_dieses_Berichts"> -->
		
				<xsl:for-each select="Kontaktdaten">
					<xsl:value-of select="concat(IK,'_',Standortnummer)"/><xsl:text>;</xsl:text>
		
					<xsl:variable name="toEscape1" select="Name" />
					<xsl:variable name="escaped1">
						<xsl:call-template name="string-replace-all">
							<xsl:with-param name="text" select="$toEscape1" />
							<xsl:with-param name="replace" select="$quote" />
							<xsl:with-param name="by" select="concat($quote, $quote)" />
						</xsl:call-template>
					</xsl:variable>			
					<xsl:value-of select="concat($quote, $escaped1, $quote)"/><xsl:text>;</xsl:text>
					
					
					<xsl:value-of select="IK"/><xsl:text>;</xsl:text>
					<xsl:value-of select="Standortnummer"/><xsl:text>;</xsl:text>
				
					<xsl:for-each select="Kontakt_Zugang">
					
						<xsl:variable name="toEscape2" select="Strasse" />
						<xsl:variable name="escaped2">
							<xsl:call-template name="string-replace-all">
								<xsl:with-param name="text" select="$toEscape2" />
								<xsl:with-param name="replace" select="$quote" />
								<xsl:with-param name="by" select="concat($quote, $quote)" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat($quote, $escaped2, $quote)"/><xsl:text>;</xsl:text>				
						
						<xsl:variable name="toEscape3" select="Hausnummer" />
						<xsl:variable name="escaped3">
							<xsl:call-template name="string-replace-all">
								<xsl:with-param name="text" select="$toEscape3" />
								<xsl:with-param name="replace" select="$quote" />
								<xsl:with-param name="by" select="concat($quote, $quote)" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat($quote, $escaped3, $quote)"/><xsl:text>;</xsl:text>
						
						<xsl:variable name="toEscape4" select="Postleitzahl" />
						<xsl:variable name="escaped4">
							<xsl:call-template name="string-replace-all">
								<xsl:with-param name="text" select="$toEscape4" />
								<xsl:with-param name="replace" select="$quote" />
								<xsl:with-param name="by" select="concat($quote, $quote)" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat($quote, $escaped4, $quote)"/><xsl:text>;</xsl:text>
						
						<xsl:variable name="toEscape5" select="Ort" />
						<xsl:variable name="escaped5">
							<xsl:call-template name="string-replace-all">
								<xsl:with-param name="text" select="$toEscape5" />
								<xsl:with-param name="replace" select="$quote" />
								<xsl:with-param name="by" select="concat($quote, $quote)" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat($quote, $escaped5, $quote)"/><xsl:text>;</xsl:text>
						
						<xsl:variable name="toEscape6" select="URL_Zugang" />
						<xsl:variable name="escaped6">
							<xsl:call-template name="string-replace-all">
								<xsl:with-param name="text" select="$toEscape6" />
								<xsl:with-param name="replace" select="$quote" />
								<xsl:with-param name="by" select="concat($quote, $quote)" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat($quote, $escaped6, $quote)"/><xsl:text>;</xsl:text>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			
		<xsl:variable name="toEscape7" select="Anzahl_Betten" />
		<xsl:variable name="escaped7">
			<xsl:call-template name="string-replace-all">
				<xsl:with-param name="text" select="$toEscape7" />
				<xsl:with-param name="replace" select="$quote" />
				<xsl:with-param name="by" select="concat($quote, $quote)" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat($quote, $escaped7, $quote)"/><xsl:text>;</xsl:text>
	
	
		<xsl:for-each select="Einleitung">
			<xsl:for-each select="Datensatz">
			
				<xsl:variable name="toEscape8" select="Datum" />
				<xsl:variable name="escaped8">
					<xsl:call-template name="string-replace-all">
						<xsl:with-param name="text" select="$toEscape8" />
						<xsl:with-param name="replace" select="$quote" />
						<xsl:with-param name="by" select="concat($quote, $quote)" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($quote, $escaped8, $quote)"/><xsl:text>;</xsl:text>
		
				
				<xsl:variable name="toEscape9" select="Uhrzeit" />
				<xsl:variable name="escaped9">
					<xsl:call-template name="string-replace-all">
						<xsl:with-param name="text" select="$toEscape9" />
						<xsl:with-param name="replace" select="$quote" />
						<xsl:with-param name="by" select="concat($quote, $quote)" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($quote, $escaped9, $quote)"/><xsl:text></xsl:text>
		
			</xsl:for-each>
		</xsl:for-each>

		</xsl:when>
    </xsl:choose>  
	    

</xsl:for-each>
</xsl:template>

<xsl:template name="string-replace-all">
    <xsl:param name="text" />
    <xsl:param name="replace" />
    <xsl:param name="by" />
    <xsl:choose>
        <xsl:when test="contains($text, $replace)">
            <xsl:value-of select="substring-before($text,$replace)"/>
            <xsl:value-of select="$by" />
            <xsl:call-template name="string-replace-all">
                <xsl:with-param name="text" 
                    select="substring-after($text,$replace)"/>
                <xsl:with-param name="replace" select="$replace"/>
                <xsl:with-param name="by" select="$by"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$text" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>