package de.narimo.commons.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

import com.csvreader.CsvWriter;

import de.narimo.commons.dto.xml.qb.Kontaktdaten;
import de.narimo.commons.dto.xml.qb.Qualitaetsbericht;

public class Krankenhaeuser2CSV {

	
//	public static void(){
//		
//		
//		
//	}
	
	
	public static void main(String[] args) throws IOException{
				       
		File outCSVFile = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_all_java_test_umbruche.csv");        
        String xmlDirectory = "G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-raw";
               
        System.out.println("Searching files to process in folder "+xmlDirectory+"...");
        
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String start = sdf.format(new Date());
        
        List<File> xmlFiles = new ArrayList<File>();
        xmlFiles = Arrays.asList(new File(xmlDirectory).listFiles());        
		System.out.println("Found "+xmlFiles.size()+" files to process.");
		 
		char csvDelimiter = ';';	
		CsvWriter w=null;
		String currentFile = null;
		
		int metaFiles = 0;
        int singleLocations = 0;
        int oneOfMultipleLocations = 0;
        int unprocessableLocations = 0;
        List<String> unprocessableLocationIds = new ArrayList<String>();
        FileInputStream fis = null;
        
		try{
						
			w = new CsvWriter(new FileWriter(outCSVFile, false), csvDelimiter);
						
//			String[] header = "ID;Name;IKNr;Standortnummer;Strasse;Hausnr;PLZ;Ort;URL;Anzahl_Betten;Erstelldatum;Erstellzeit;Timestamp".split(String.valueOf(csvDelimiter));
			String[] header = "ID;Name;IKNr;Standortnummer;Strasse;Hausnr;PLZ;Ort;URL;Anzahl_Betten;Erstelldatum".split(String.valueOf(csvDelimiter));
			for(String h : header){
				w.write(h);
			}
			w.endRecord();			
			w.flush();
			
			int cnt=0;
			for(File xmlFile : xmlFiles){
		    	
		    	if (!xmlFile.isFile() || !xmlFile.getName().endsWith(".xml")) continue;
		    	
		    	currentFile = xmlFile.getName();
		    	System.out.println("Processing file "+currentFile+".");
		    	
		    	JAXBContext jc = JAXBContext.newInstance(Qualitaetsbericht.class);	
			    Unmarshaller unmarshaller = jc.createUnmarshaller();
			    XMLInputFactory xmlif = XMLInputFactory.newInstance();
			    
			    fis = new FileInputStream(xmlFile);
			    XMLStreamReader xmler = xmlif.createXMLStreamReader(fis);	        
		        Qualitaetsbericht qb = (Qualitaetsbericht) unmarshaller.unmarshal(xmler);
		    	
		        
		        String lastId = "";
		        
		    	if(qb.getStandorte()!=null) {
		    		metaFiles++;
		    		continue;
		    	}
		    	
		    	String id = null;
		    	String name = null;
		    	String iknr = null;
		    	String standortnummer = null;
		    	String strasse = null;
		    	String hausnr = null;
		    	String plz = null;
		    	String ort = null;
		    	String url = null;
		    	String anzahlBetten = null;
		    	String erstelldatum = null;
		    	String erstellzeit = null;
		    	
		    	Kontaktdaten kontaktdaten = null;
		    	
		    	if(qb.getEinzigerStandort()!=null){
		    		
		    		singleLocations++;		    		
		    		kontaktdaten = qb.getKrankenhaus().getKontaktdaten();
//		    		System.out.println("Getting kontaktdaten from Krankenhaus.");
//		    		if(kontaktdaten==null) System.out.println("Kontaktdaten is null.");		
		    		
		    	}else if(qb.getEinzigerStandort()==null && qb.getStandort()!=null){
		    		
		    		oneOfMultipleLocations++;
		    		kontaktdaten = qb.getStandort().getKontaktdaten();
//		    		System.out.println("Getting kontaktdaten from this location. iknr: "+qb.getStandort().getKontaktdaten().getIk());
//		    		if(kontaktdaten==null) System.out.println("Kontaktdaten is null.");
		    		
		    	}else{
		    		unprocessableLocations++;
		    		unprocessableLocationIds.add(lastId); //add the id from the last processable location as a reference
		    		continue;
		    	}
		    	
		    	iknr = kontaktdaten.getIk();
	    		standortnummer = kontaktdaten.getStandortNummer();
	    		
	    		id = iknr+"_"+standortnummer;
	    		
	    		name = kontaktdaten.getName().replace("\n", " ");
	    		strasse = kontaktdaten.getKontaktZugang().getStrasse();
	    		hausnr = kontaktdaten.getKontaktZugang().getHausnummer();
	    		plz = kontaktdaten.getKontaktZugang().getPlz();
	    		ort = kontaktdaten.getKontaktZugang().getOrt();
	    		url = kontaktdaten.getKontaktZugang().getUrl();	    		
	    		
	    		anzahlBetten = qb.getAnzahlBetten();
	    		erstelldatum = qb.getEinleitung().getDatensatz().getDatum();
	    		erstellzeit = qb.getEinleitung().getDatensatz().getUhrzeit();

				w.write(id);
				w.write(name);
				w.write(iknr);
				w.write(standortnummer);
				w.write(strasse);
				w.write(hausnr);
				w.write(plz);
				w.write(ort);
				w.write(url);
				w.write(anzahlBetten);
//				w.write(erstelldatum);
//				w.write(erstellzeit);
				w.write(erstelldatum+" "+erstellzeit);
				
			
				w.endRecord();
				
//				w.flush();
				if ((cnt % 50) == 0) w.flush();
				
				fis.close();
				cnt++;
//				break;
			}
							
			w.flush();		
		
		} catch (Exception e) {
			System.out.println("Error while processing file "+currentFile+".");
			e.printStackTrace();
			w.close();
			fis.close();
		}
		
        
        String fin = sdf.format(new Date());
        System.out.println("Started operation at "+start+".");
        System.out.println("Finished operation at "+fin+".");
        
        
        System.out.println("Single locations: "+singleLocations+".");
        System.out.println("Incorporated locations: "+oneOfMultipleLocations+".");
        System.out.println("Meta location files: "+metaFiles+".");
        System.out.println("Unprocessable locations: "+unprocessableLocations+".");
        
	}
}
