package de.narimo.commons;

import java.util.LinkedHashMap;
import java.util.Map;

public class CacheMap<K, V> extends LinkedHashMap<K, V> {
    private int MAX_ENTRIES = 100;

    public CacheMap(int maxCacheSize) {
        this.MAX_ENTRIES = maxCacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return size() > MAX_ENTRIES;
    }
}