package de.narimo.commons.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;

import de.narimo.commons.dto.csv.bna.Powerplant;
import de.narimo.commons.dto.csv.bna.PowerplantAttribute;

public class CSVTools {

	/**
	 * 
	 * Concatenates two csv files having the same header signature into a single csv file.
	 * Removes empty lines.
	 * 
	 * @param csvFiles
	 */
	public static void concatCSVFiles(List<File> csvFiles, File outputCSVFile, char delimiter){
		
		CsvReader r=null;
		CsvWriter w=null;
	
		try{
						
			w = new CsvWriter(new FileWriter(outputCSVFile, false), delimiter);
			String[] header = null;
			
			for(File csvFile : csvFiles){				
			
				r = new CsvReader(csvFile.getAbsolutePath(), delimiter, StandardCharsets.UTF_8);
				r.readHeaders();
								
				String[] headers = r.getHeaders();
				
				if(header==null){
					header = headers;
					
					for(int i=0; i<headers.length; i++){
						w.write(headers[i]);
					}				
					w.endRecord();
					w.flush();
					
				}else{
//					if(headers==header) throw new RuntimeException("Header of file "+csvFile+" does not equal expected header signature.");
					if (!Arrays.equals(headers, header)) throw new RuntimeException("Header of file "+csvFile+" does not equal expected header signature.");
				}
							
					
				while(r.readRecord()){
					String[] values = r.getValues();
					if(recordIsEmpty(values)) continue;
					
					for(int i=0; i<values.length; i++){
						w.write(values[i]);
					}				
					w.endRecord();
					
					w.flush();
				}					
				r.close();
			}
		
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(w!=null) w.close();
			if(r!=null) r.close();
		}
	}
	
	
	public static File csv2ObjectList(File csvgeom, File csvatt, Charset charset, char separator) throws Exception{
		
		//using csv reader
//		CsvReader r = new CsvReader(arg0);
//		r.readRecord();
//		r.getRawRecord()
		
		
		//using jackson, see https://github.com/FasterXML/jackson-dataformats-text/tree/master/csv
				
		//input stuff
		CsvMapper mapper = new CsvMapper();
		CsvSchema geomSchema = CsvSchema.emptySchema().withHeader().withColumnSeparator(separator);
//		MappingIterator<PowerplantGeometry> geom = mapper.readerFor(PowerplantGeometry.class).with(geomSchema).readValues(csvgeom);
		MappingIterator<Powerplant> geom = mapper.readerFor(Powerplant.class).with(geomSchema).readValues(csvgeom);
		
		FileInputStream fis = new FileInputStream(csvatt);
		InputStreamReader isr = new InputStreamReader(fis, charset);
		
//		CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(';');
//		MappingIterator<PowerplantAttribute> at = mapper.readerFor(PowerplantAttribute.class).with(geomSchema).readValues(csvatt);
		MappingIterator<PowerplantAttribute> at = mapper.readerFor(PowerplantAttribute.class).with(geomSchema).readValues(isr);
		
		//output stuff
		CsvSchema outSchema = mapper.schemaFor(Powerplant.class).withColumnSeparator(separator);
//		CsvWriter w = new CsvWriter(new FileWriter(csvOutFile, false), delimiter);
		File csvOutFile = new File(csvatt.getAbsolutePath()+"-out.csv");
//		HashSet<HashSet<String>> output = new HashSet<HashSet<String>>();
		
		FileOutputStream fos = new FileOutputStream(csvOutFile);
		OutputStreamWriter osw = new OutputStreamWriter(fos, charset);
		
		//algorithm
		List<Powerplant> plantsGeoms = geom.readAll();
		List<PowerplantAttribute> plantsAtts = at.readAll();
		
		
		List<Powerplant> plantsMerged = new ArrayList<Powerplant>();
		
//		//Add csv header
//		HashSet<String> o = new HashSet<String>();
//		o.add("Kraftwerksnummer");
//		o.add("Unternehmen");
//		o.add("Kraftwerksname");
//		o.add("BlockId");
//		o.add("Blockname");
//		o.add("LeistungMW");
//		o.add("StromnetzBetreiber");						
//		o.add("PLZ");
//		o.add("Ort");
//		o.add("Adresse");
//		o.add("Bundesland");
//		o.add("Erzeugungsbeginn");
//		o.add("Status");
//		o.add("Energieträger");
//		o.add("Hauptbrennstoffe");
//		o.add("Zusatzbrennstoffe");
//		o.add("Hauptbrennstoff");
//		o.add("EEGAnlage");
//		o.add("Waermeauskopplung");
//		o.add("NetzebeneKV");
//		o.add("Verknuepfungspunkt");
//		o.add("Latitude");
//		o.add("Longitude");	
//		output.add(o);
		
		
		for(Powerplant g : plantsGeoms){

			if(g.getKraftwerksnummer()!=null){
				
				for(PowerplantAttribute a : plantsAtts){

					if(a.getKraftwerksnummer().equals(g.getKraftwerksnummer())){
						
						
						Powerplant p = new Powerplant();
						p = g;
						p.setAdresse(a.getAdresse());
						p.setBlockname(a.getBlockname());
						p.setLeistungMW(a.getLeistungMW());
						p.setBundesland(a.getBundesland());
						p.setEEGAnlage(a.getEEGAnlage());
						p.setEnergieträger(a.getEnergieträger());
						p.setErzeugungsbeginn(a.getErzeugungsbeginn());
						p.setHauptbrennstoff(a.getHauptbrennstoff());
						p.setHauptbrennstoffe(a.getHauptbrennstoffe());
						p.setKraftwerksname(a.getKraftwerksname());
						p.setNetzebeneKV(a.getNetzebeneKV());
						p.setOrt(a.getOrt());
						p.setPLZ(a.getPLZ());
						p.setStatus(a.getStatus());
						p.setStromnetzBetreiber(a.getStromnetzBetreiber());
						p.setUnternehmen(a.getUnternehmen());
						p.setVerknuepfungspunkt(a.getVerknuepfungspunkt());
						p.setWaermeauskopplung(a.getWaermeauskopplung());
						p.setZusatzbrennstoffe(a.getZusatzbrennstoffe());
						plantsMerged.add(p);
						
						
//						o = new HashSet<String>();
//						o.add(g.getKraftwerksnummer());
//						o.add(a.getUnternehmen());
//						o.add(a.getKraftwerksname());
//						o.add(g.getBlockId());
//						o.add(a.getBlockname());
//						o.add(a.getLeistungMW());
//						o.add(a.getStromnetzBetreiber());						
//						o.add(a.getPLZ());
//						o.add(a.getOrt());
//						o.add(a.getAdresse());
//						o.add(a.getBundesland());
//						o.add(a.getErzeugungsbeginn());
//						o.add(a.getStatus());
//						o.add(a.getEnergieträger());
//						o.add(a.getHauptbrennstoffe());
//						o.add(a.getZusatzbrennstoffe());
//						o.add(a.getHauptbrennstoff());
//						o.add(a.getEEGAnlage());
//						o.add(a.getWaermeauskopplung());
//						o.add(a.getNetzebeneKV());
//						o.add(a.getVerknuepfungspunkt());
//						o.add(String.valueOf(g.getLatitude()));
//						o.add(String.valueOf(g.getLongitude()));
//
//						
//						output.add(o);
						
						break;
					}

					
				}
			}
			
			
			
		}
		
		int cnt = 1;
	
		//use CSVWriter
//		writeToCSVFile(output, csvOutFile, separator, charset);
		
		
		//use jackson
		
		//TODO: This writes too long records to csv file.
		//Each record contains alll values twice due to Plant annotation "JsonPropertyOrder".
		// Maybe better use normal CsvWriter
		 mapper.writer(outSchema).writeValue(osw, plantsMerged);
		 
		 return csvOutFile;
	}
	
	public static boolean recordIsEmpty(String[] record){
		for(int i=0; i<record.length; i++){
			if(record[i].trim().length()>0) return false;
		}	
		return true;
	}
	
	
	public static File addHeaderToFile(List<String> headerL, File csvFile, char delimiter, Charset charset){
				
		CsvReader r=null;
		CsvWriter w=null;
	
		File csvOutFile = new File(csvFile.getAbsolutePath()+"-out.csv");
		
		try{
									
			w = new CsvWriter(new FileWriter(csvOutFile, false), delimiter);

			r = new CsvReader(csvFile.getAbsolutePath(), delimiter, charset);
	
			//Write new header
			for(String head : headerL){
				w.write(head);
			}
			w.endRecord();
	
			while(r.readRecord()){
				String[] values = r.getValues();
				if(recordIsEmpty(values)) continue;
				
				for(int i=0; i<values.length; i++){
					w.write(values[i]);
				}				
				w.endRecord();
				
				w.flush();
			}					
			r.close();
		
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(w!=null) w.close();
			if(r!=null) r.close();
		}
		
		return csvOutFile;
	}
	
	
	public static File writeToCSVFile(HashSet<HashSet<String>> set, File csvOutFile, char delimiter, Charset charset){
		
		CsvWriter w=null;

		try{
									
			w = new CsvWriter(new FileWriter(csvOutFile, false), delimiter);


			Iterator<HashSet<String>> it = set.iterator();
			while(it.hasNext()){
				HashSet<String> sub = it.next();
				Iterator<String> subit = sub.iterator();
				
				while(subit.hasNext()){					
					String s = subit.next();
					s = s.replace("\n", " ");
					s = s.replace("\r", " ");
					w.write(s);
				}
				
				w.endRecord();				
				w.flush();
			}
				
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(w!=null) w.close();
		}
		
		return csvOutFile;
	}
	
	
	public static void main(String args[]) throws Exception {
		
		
		char csvSeparator = ';';
		Charset charset = StandardCharsets.ISO_8859_1;
		File csvFile = new File("C:/Users/admin/Desktop/Kraftwerksliste_CSV_2017-11 (2).csv");
		
		List<String> headerL = new ArrayList<String>();
		headerL.add("Kraftwerksnummer Bundesnetzagentur");
		headerL.add("Unternehmen");
		headerL.add("Kraftwerksname");
		headerL.add("PLZ");
		headerL.add("Ort");
		headerL.add("Straße und Hausnummer");
		headerL.add("Bundesland");
		headerL.add("Blockname");
		headerL.add("Aufnahme der kommerziellen Stromerzeugung (Jahr)");
		headerL.add("Kraftwerksstatus");
		headerL.add("Energieträger");
		headerL.add("Spezifizierung Hauptbrennstoff");
		headerL.add("Spezifizierung Zusatzbrennstoffe");
		headerL.add("Hauptenergieträger");
		headerL.add("Vergütungsfähig nach EEG");
		headerL.add("Wärmeauskopplung");
		headerL.add("Netto-Nennleistung in MW");
		headerL.add("Verknüpfungspunkt Stromnetz");
		headerL.add("Netzebene in kV");
		headerL.add("Name Stromnetzbetreiber");
		File csvModifiedFile = addHeaderToFile(headerL, csvFile, csvSeparator, charset);
		
		 File readGeomFile = new File("C:/Users/admin/Desktop/BNA_power_plant_geometries.csv");
//		 File readAttFile = new File("C:/Users/admin/Desktop/Kraftwerksliste_CSV_2017-11.csv");
//		 File readAttFile = new File("C:/Users/admin/Desktop/Kraftwerksliste_CSV_2017-11 (2).csv");
//		 File readAttFile = new File("C:/Users/admin/Desktop/Kraftwerksliste_CSV_2017-11 (2).csv-out.csv");
		 File readAttFile = csvModifiedFile;
		 
		 File outfile = csv2ObjectList(readGeomFile, readAttFile, charset, csvSeparator);
		
		 addHeaderToFile(headerL, outfile, csvSeparator, charset);
		 
		if(true) return;
		
//		 File outCSVFile = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_merged.csv");
//		 
//		 File csvFile1 = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015.csv");
//		 File csvFile2 = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_singles.csv");
//		 
//		 List<File> csvFiles = new ArrayList<File>();
//		 csvFiles.add(csvFile1);
//		 csvFiles.add(csvFile2);
//		 
//		 mergeCSVFiles(csvFiles, outCSVFile, ';');
//		 
//		 System.out.println("Merge finished for "+csvFiles.size()+" files.");
	}
	

}
