package de.narimo.geocore.ws.auth.filter;

import java.io.IOException;

import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;

/** 
 * @deprecated Ensuring backwards compatibility only!!! 
 * 
 * Class used in a proxy setting, where authentication is not needed but authentication information must be stored
 * to request subsequent components.
 * 
 * @author Ulrich Mann
 *
 */

@Provider
@Priority(Priorities.AUTHENTICATION)
public class AuthenticationRegistrationFilter implements ContainerRequestFilter{

	@Context
	private HttpServletRequest httprequest;

	public void filter(ContainerRequestContext requestContext) throws IOException{
		
		System.out.println(this.getClass().getSimpleName());
		
		HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
		
		try {
				
			Cookie sessionCookieIn = AuthenticationFilterTools.getSessionCookie(httprequest, "narimosessid");

			//TODO add cookie functionality
			if(sessionCookieIn!=null) {
				long t = System.currentTimeMillis();
				Cookie sessionCookie = new Cookie("narimosessid", sessionCookieIn.getValue(), "/geometa-server/", null); //cookie will be provided from ui; needed for auth at geometa-server
				Cookie timeCookie = new Cookie("serverTime", String.valueOf(t));
				Cookie expiryCookie = new Cookie("sessionExpiry", String.valueOf(t));
			
				Cookie[] cs = new Cookie[]{sessionCookie, timeCookie, expiryCookie};
				authFactory.setSessionCookies(cs);
			}
				
			UserCredentials credentials = AuthenticationFilterTools.getUserCredentials(httprequest);
			if (credentials != null) authFactory.setCredentials(credentials);

			requestContext.setProperty("authFactory", authFactory);
			
		}catch(Exception e){
			e.printStackTrace();
			System.out.println("Couldn't set authentication details in "+this.getClass().getSimpleName());
		}
	}
		
}
