package de.narimo.geocore.ws.auth;

import java.security.Principal;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;

/**
 * A custom security context for request filters. 
 * @see http://stackoverflow.com/questions/17068528/authorization-with-rolesalloweddynamicfeature-and-jersey 
 * @author Ulrich Mann 
 * 
 */
public class OverrideSecurityContext implements SecurityContext {

	String user;
	List<String> userRoles;
	HttpServletRequest request;
	
	public OverrideSecurityContext(String user, List<String> roles, HttpServletRequest request) {		
		this.user = user;
		this.userRoles = roles;
		this.request = request;
	}	

	@Override
	public Principal getUserPrincipal() {

		if (this.user == null) {return request.getUserPrincipal();}
		
		return new Principal() {
			@Override
			public String getName() {return user;}
		};
	}
	
	@Override
	public String getAuthenticationScheme() {return null;}
	
	@Override
	public boolean isSecure() {return false;}
	
	@Override
	public boolean isUserInRole(String role) {
		
		if (userRoles == null) {
			 return request.isUserInRole(role);
		}
			 return userRoles.contains(role);
	}
}
