package de.narimo.geocore.ws.auth.filter;

import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;

/**
 * 
 * Request filter class for cookie authentication.
 * This filter class should not be used for authentication itself. Use Filter implementations overriding authenticate() method.
 * If no authentication details have been provided, filter refuses a request including www-authenticate header.
 * 
 * @author Ulrich Mann
 *
 */
//@Provider
//@Priority(Priorities.AUTHENTICATION)
public abstract class CookieAuthenticationFilter extends BasicAuthenticationFilter{

	public void filter(ContainerRequestContext requestContext) throws IOException{
		
		System.out.println(this.getClass().getSimpleName());

		try {
			this.filterCookie(requestContext);			
		} catch (Exception e) {
			e.printStackTrace();
			refuseRequest403(requestContext);
		}finally{}			
	}

	
	void filterCookie(ContainerRequestContext requestContext) throws Exception{
				
		String allowCookieAuth = ctx.getInitParameter("ALLOW_COOKIE_AUTH");
		if(allowCookieAuth==null || !allowCookieAuth.equals("true")) {
			this.filterBasic(requestContext);
			return;
		}
				
		System.out.println("Checking cookie auth...");
		
		UserCredentials credentials;
		
		//TRY COOKIE AUTHENTICATION
		Cookie sessionCookie = AuthenticationFilterTools.getSessionCookie(httprequest, "narimosessid");
		String sessionToken = sessionCookie==null ? null : sessionCookie.getValue();
		
		if(sessionToken==null) {
			//No such token provided? Proceed with basic auth...
			this.filterBasic(requestContext);
			return;
		}
		
//		if(sessionToken!=null) {
			credentials = authenticateJSESSIONIDToken(requestContext, sessionToken);
//		}
//		else{
//		
//			this.filterBasic(requestContext);
//			return;
//		}
		
		if(!this.checkCredentials(requestContext, credentials)) return;
		
		System.out.println("CookieAuthenticationFilter, authentication successful for " + credentials.getUsername() + ":" + "token from cookie set="+(credentials.getPassword()==null?"no":"yes"));
		
		this.prepareSecurityContext(requestContext, credentials);
	}
	
	
	/**
	 * Authentication method for session tokens which must be overridden by implementing filters.
	 * This filter class should not be used for authentication itself.
	 */
	public UserCredentials authenticateJSESSIONIDToken(ContainerRequestContext requestContext, String sessionToken) throws Exception{
		throw new UnsupportedOperationException("Invalid authentication filter base class. Use a custom filter implementation.");
	}
	
}
