package de.narimo.geocore.ws.login;

import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;

import de.narimo.commons.dto.geometa.User;
import de.narimo.commons.json.JsonConverter;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.JWTFactory;
import de.narimo.geocore.ws.repository.UserRepository;

public class LoginProvider {

    /**
     * Creates the response for a login request.
     * 
     * @param ctx
     * @param request
     * @param loggedInUser
     * @return
     */
    public static Response createLoginResponse(
            ServletContext ctx, HttpServletRequest request, String loggedInUser, String workspacePermissionType) {

        ResponseBuilder rb;

        try {
            rb = Response.ok();

            // TODO: currently using token created by geonetwork in
            // GeonetworkAuthenticationFilter. Should we create a custom one?
            Cookie c = ((HTTPAuthorizationFactory) request.getAttribute("authFactory")).getSessionCookies()[0];
            if (c == null) {
                throw new AuthenticationException("No valid login credentials.");
            }
            if (!c.getName().equals("GSESSIONID")) {
                throw new IllegalStateException("No valid authentication details provided.");
            }

            String sessionToken = c.getValue();
            System.out.println("Created session for user " + loggedInUser + " with token: " + sessionToken);

            if (ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET") == null) {
                throw new IllegalStateException("Define jwt server secret!");
            }

            // Create JWT including gn session token
            JWTFactory jwtFactory = new JWTFactory(ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET"),
                    ctx.getInitParameter("JWT_ISSUER"));
            jwtFactory.setAccessToken(sessionToken);
            // JWT has no duration itself, just the underlying JSESSIONID
            String jwtToken = jwtFactory.createToken(0);

            rb.header("x-narimosessid", jwtToken);

            User user = UserRepository.getUser(loggedInUser).get();
            if (workspacePermissionType != null) {
                user.setType(workspacePermissionType);
            }

            // Include user object to be identified client-side, e.g. for
            // password reset
            rb.entity(JsonConverter.toJson(user));

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("Login: Successful, but no session created as no session token has been provided.");
            rb = Response.status(403);
        }
        return rb.build();
    }

    /**
     * Creates the response for a logout request
     *
     * @param request
     * @param serverApplication
     * @return
     */
    public static Response createLogoutResponse(
            HttpServletRequest request, String serverApplication) {

        // Setting attribute stateless will destroy session in
        // GeonetworkSessionHandler on outgoing response
        request.setAttribute("stateless", true);

        ResponseBuilder rb = Response.ok();
        NewCookie c = new NewCookie("narimosessid", "", "/" + serverApplication + "/", null, null, 0, true);
        rb.cookie(c);

        return rb.build();
    }
}
