package de.narimo.geocore.ws.auth.filter;

import java.io.IOException;

import javax.annotation.Priority;
import javax.servlet.ServletContext;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.ws.http.CookieTools;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;

@Provider
@Priority(Priorities.USER)
public class GeorepoSessionHandler implements ContainerResponseFilter{

	@Context ServletContext ctxt;

	@Override
	public void filter(ContainerRequestContext requestContext,
			ContainerResponseContext responseContext) throws IOException {

		System.out.println(this.getClass().getSimpleName());
		System.out.println("Stateless request: "+requestContext.getProperty("stateless"));

		if(requestContext.getProperty("stateless")!=null && ((Boolean) requestContext.getProperty("stateless"))==true){
			/**
			 * Terminate session for api requests authorized with user/ pass and no inherent session
			 */
			System.out.println("Terminating session context for stateless request.");
			try{
				Cookie[] cs = ((HTTPAuthorizationFactory) requestContext.getProperty("authFactory")).getSessionCookies();
				Cookie sessionCookie = CookieTools.getCookie(cs, "GSESSIONID");
				if(sessionCookie!=null){
					String sessionid = sessionCookie.getValue();
					//setting remove to true will remove a session completely from session store after it got invalid
					AuthenticationTools.destroySession(sessionid, false);
				}
			}catch(Exception e){
				System.out.println("Logout error. Probably session has not been removed correctly.");
				e.printStackTrace();
			}
		}
	}
}
