package de.narimo.geocore.ws.auth.filter;

import javax.annotation.Priority;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.ApiKeyAuth;
import de.narimo.geocore.ws.auth.GeorepoBasicAuthentication;
import de.narimo.geocore.ws.auth.SessionTokenAuth;

/**
 * Authentication filter class using georepo login capabilities.
 *
 * @author Ulrich Mann
 */

@Provider
@Priority(Priorities.AUTHENTICATION)
public class GeorepoAuthenticationFilter extends ApiKeyAuthenticationFilter{

	@Context
	ServletContext ctx;

	@Context
	UriInfo uriinfo;

	@Context HttpServletRequest request;

	/**
	 * Authentication method using georepo login capabilities.
	 */
	@Override
	public void authenticateBasic(ContainerRequestContext requestContext, UserCredentials credentials) throws Exception{
		GeorepoBasicAuthentication.authenticateBasic(this.ctx, requestContext, this.uriinfo, credentials);
	}

	@Override
	public UserCredentials authenticateJSESSIONIDToken(ContainerRequestContext requestContext, String sessionToken) throws Exception{
		return SessionTokenAuth.authenticateSessionToken(this.ctx, requestContext, sessionToken);

	}

	@Override
	public UserCredentials authenticateApiKey(ContainerRequestContext requestContext, String apiKey) throws Exception{
		return ApiKeyAuth.authenticateApiKey(requestContext, apiKey);
	}
}
