package de.narimo.geocore.ws.auth;

import java.net.URL;

import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;

/**
 * @author Ulrich
 */
public class GeorepoBasicAuthentication {

    public static void authenticateBasic(
            ServletContext ctx,
            ContainerRequestContext requestContext,
            UriInfo uriinfo,
            UserCredentials credentials) throws Exception {

        boolean createSession = false; // default should be 'create no session', i.e. remove it on response;

        try {
            String sessionParam = uriinfo.getQueryParameters().get("sess").get(0);
            createSession = Boolean.parseBoolean(sessionParam);
        } catch (Exception e) {
        }

        System.out.println("Create permanent session? " + createSession);

        String sessionId = null;
        sessionId = AuthenticationTools.createSession(credentials.getUsername(), credentials.getPassword());
        if (!createSession) {
            requestContext.setProperty("stateless", true); // will destroy the current session after this request
                                                           // finished with a response
        }

        String georepoUrl = ctx.getInitParameter("georepoUrlInternal");
        if (georepoUrl == null) {
            throw new IllegalStateException("Context parameter georepoUrlInternal is not defined.");
        }

        HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();

        Cookie sessionCookie = new Cookie("GSESSIONID", sessionId, new URL(georepoUrl).getPath(), "localhost");
        if (sessionCookie != null) {
            authFactory.setSessionCookies(new Cookie[] { sessionCookie });
        }
        if (credentials != null) {
            authFactory.setCredentials(credentials);
        }
        requestContext.setProperty("authFactory", authFactory);
    }
}
