package de.narimo.geocore.ws.auth.filter;


import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.ApiKeyAuth;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;

/**
 * 
 * Request filter class for apikey authentication.
 * This filter class should not be used for authentication itself. Use Filter implementation.
 * If no authentication details have been provided, filter refuses a request including www-authenticate header.
 * 
 * @author Ulrich Mann
 *
 */
public abstract class ApiKeyAuthenticationFilter extends BearerAuthenticationFilter{
	
//	@Context HttpServletRequest request;
	
	public void filter(ContainerRequestContext requestContext) throws IOException{
		
		System.out.println(this.getClass().getSimpleName());
		
		try {	
			
			this.filterApiKey(requestContext);
		} catch (Exception e) {
			e.printStackTrace();
			refuseRequest403(requestContext);
		}finally{}			
	}
	
	void filterApiKey(ContainerRequestContext requestContext) throws Exception{
				
		String allowApiKeyAuth = ctx.getInitParameter("ALLOW_APIKEY_AUTH");
		if(allowApiKeyAuth==null || !allowApiKeyAuth.equals("true")) {
			this.filterBearer(requestContext);
			return;
		}
		
		System.out.println("Checking apikey auth...");

		String apiKey = AuthenticationFilterTools.getApiKey(requestContext.getUriInfo());
		
		if(apiKey==null) {
			//No api key provided? Proceed with bearer auth...
			this.filterBearer(requestContext);
			return;
		}

		UserCredentials credentials = ApiKeyAuth.authenticateApiKey(requestContext, apiKey);

		if(!this.checkCredentials(requestContext, credentials)) return;
		
		System.out.println("ApiKeyAuthFilter, authentication successful for " + credentials.getUsername() + ".");
		
		this.prepareSecurityContext(requestContext, credentials);
	}
	
	/**
	 * Authentication method for session tokens which must be overridden by implementing filters.
	 * This filter class should not be used for authentication itself.
	 */
	public UserCredentials authenticateApiKey(ContainerRequestContext requestContext, String apiKey) throws Exception{
		throw new UnsupportedOperationException("Invalid authentication filter base class. Use a custom filter implementation.");
	}
}
