package de.narimo.geocore.ws.auth.tools;

import java.util.Base64;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.CookieTools;

public class AuthenticationFilterTools {

	public static UserCredentials getUserCredentials(HttpServletRequest request) {

		String user = null;
		String pass = null;

		UserCredentials credentials = new UserCredentials();
		
		try {
			String authHead = request.getHeader("Authorization");
			if (authHead!=null && !authHead.equals("")) {
//				String authCredentials = Base64.decodeAsString(authHead.substring(6));
				String authCredentials = new String(Base64.getDecoder().decode(authHead.substring(6)));
				user = authCredentials.substring(0, authCredentials.indexOf(":"));
				pass = authCredentials.substring(authCredentials.indexOf(":") + 1);
				credentials.setUserCredentials(user, pass);
				return credentials;
			} else return null;
		} catch (Exception e) {return null;}
	}
	
	public static String getBearerToken(HttpServletRequest request) {

		try {
			String authHead = request.getHeader("Authorization");
			if (authHead!=null && !authHead.equals("")) {
				if(!authHead.startsWith("Bearer")) return null;
				
				return authHead.substring(7);

			} else return null;
		} catch (Exception e) {return null;}
	}
	
	public static Cookie getSessionCookie(HttpServletRequest request, String cookiename) {
		
		try{
			String authHead = request.getHeader("Cookie");
	
			if (authHead==null || authHead.equals("")) return null;
			return CookieTools.getCookie(authHead, cookiename);

		} catch (Exception e) {return null;}
	
	}
	
	public static String getApiKey(UriInfo uriinfo) {

		try {
			String apikey = uriinfo.getQueryParameters().get("apikey").get(0);
			if (apikey==null || apikey.equals("")) {
				apikey = uriinfo.getQueryParameters().get("APIKEY").get(0);
			}
			
			if (apikey==null || apikey.equals("")) return null;
			return apikey;	
		
		} catch (Exception e) {return null;}
	}
	
	
	public static void main(String[] args) throws Exception{
	
//		String authHead = "Bearer asoifh24t90";
//		String bearerToken = authHead.substring(7);
//		System.out.println("token: "+bearerToken);
	
	}
	
}
