package de.narimo.geocore.ws.auth;

import java.net.URL;

import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;

public class SessionTokenAuth {

    public static UserCredentials authenticateSessionToken(
            ServletContext ctx,
            ContainerRequestContext requestContext,
            String sessionToken) throws Exception {

        UserCredentials loggedInUser = AuthenticationTools.getAndRenewLoggedInUser(sessionToken);
        if (loggedInUser == null) {
            AuthenticationException ae = new AuthenticationException("Session id not valid.");
            ae.printStackTrace();
            throw ae;
        } else {

            HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
            String georepoUrl = ctx.getInitParameter("georepoUrlInternal");
            if (georepoUrl == null) {
                throw new IllegalStateException("Context parameter georepoUrlInternal is not defined.");
            }

            Cookie sessionCookie = new Cookie("GSESSIONID", sessionToken, new URL(georepoUrl).getPath(), null);
            if (sessionCookie != null) {
                authFactory.setSessionCookies(new Cookie[] { sessionCookie });
            }
            requestContext.setProperty("authFactory", authFactory);

            return loggedInUser;
        }
    }
}
