package de.narimo.geocore.ws.auth.filter;

import java.io.IOException;

import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.JWTFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;

/**
 * 
 * Request filter class for bearer authentication.
 * This filter class should not be used for authentication itself. Use Filter implementations overriding authenticate() method.
 * If no authentication details have been provided, filter refuses a request including www-authenticate header.
 * 
 * @author Ulrich Mann
 *
 */
//@Provider
//@Priority(Priorities.AUTHENTICATION)
public abstract class BearerAuthenticationFilter extends CookieAuthenticationFilter{
	
	public void filter(ContainerRequestContext requestContext) throws IOException{
		
		System.out.println(this.getClass().getSimpleName());
		
		try {	
			this.filterBearer(requestContext);
		} catch (Exception e) {
			e.printStackTrace();
			refuseRequest403(requestContext);
		}finally{}			
	}
	
	void filterBearer(ContainerRequestContext requestContext) throws Exception{
				
		String allowBearerAuth = ctx.getInitParameter("ALLOW_BEARER_AUTH");
		if(allowBearerAuth==null || !allowBearerAuth.equals("true")) {
			this.filterCookie(requestContext);
			return;
		}
		
		System.out.println("Checking bearer auth...");
				
		UserCredentials credentials;	
		
		//TRY BEARER AUTHENTICATION
		String bearerToken = AuthenticationFilterTools.getBearerToken(httprequest);
		
		if(bearerToken==null) {
			//No such token provided? Proceed with cookie auth...
			this.filterCookie(requestContext);
			return;
		}
		
		JWTFactory jwtFactory = new JWTFactory(ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET"), ctx.getInitParameter("JWT_ISSUER"));
		
		String sessionToken = null;
		
		boolean isValid = false;
//		try{
			isValid = jwtFactory.verifyToken(bearerToken);
//		}catch(TokenExpiredException tex){
//			throw tex;
//		}catch(SignatureVerificationException sve){
//			throw sve;
//		}
		
		if(isValid) sessionToken = jwtFactory.getAccessToken(bearerToken);		
		
		if(sessionToken==null){
			throw new ForbiddenException("No valid session id provided with bearer token.");
		}
//		if(sessionToken!=null){
			credentials = authenticateJSESSIONIDToken(requestContext, sessionToken);
//		}else{
//			//TODO: only proceed with filter cookie, if no bearer token provided; NOT, if it was invalid!!!
//			this.filterCookie(requestContext);
//			return;
//		}		
		
		if(!this.checkCredentials(requestContext, credentials)) return;
		
		System.out.println("BearerAuthenticationFilter, authentication successful for " + credentials.getUsername() + ":" + " bearer token set="+(credentials.getPassword()==null?"no":"yes"));
		
		this.prepareSecurityContext(requestContext, credentials);
	}
}
