package de.narimo.geocore.ws.auth.filter;

import javax.annotation.Priority;
import javax.servlet.ServletContext;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.GeorepoBasicAuthentication;

@Provider
@Priority(Priorities.AUTHENTICATION)
public class InternalBasicFilter extends BasicAuthenticationFilter{

	@Context
	ServletContext ctx;

	@Context
	UriInfo uriinfo;

	/**
	 * Authentication method using georepo login capabilities.
	 */
	@Override
	public void authenticateBasic(ContainerRequestContext requestContext, UserCredentials credentials) throws Exception{
		GeorepoBasicAuthentication.authenticateBasic(this.ctx, requestContext, this.uriinfo, credentials);

		//is this sufficient to check for admin user, once we are authenticated successful??
		if(!credentials.getUsername().equals("admin")) {
			throw new ForbiddenException("No access permission granted for user "+credentials.getUsername()+".");
		}
	}
}