package de.narimo.geocore.ws.auth.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.naming.AuthenticationException;

import org.apache.commons.lang3.RandomStringUtils;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;

/**
 *
 * @author Ulrich
 *
 */
public class AuthenticationTools {

    /**
     * Authenticates a user and returns the created sessionId.
     *
     * @param userName
     * @param userPass
     * @return
     * @throws Exception
     */
    public static String createSession(String userName, String userPass) throws Exception {

        String sessionId = null;
        JDBCConnectionJNDI jdbcAuth = null;
        try {
            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            System.out.println(
                    "Attempting to create session for " + userName + " | pass?=" + (userPass != null ? "yes" : "no"));

            // authenticate user
            String sql = "SELECT 1 FROM public.users where username ILIKE ? and enabled=true and password=sha256g(?)";

            PreparedStatement ps = jdbcAuth.prepareStatement(sql);
            ps.setString(1, userName);
            ps.setString(2, userPass);
            ResultSet rs = ps.executeQuery();

            if (!rs.next()) {
                throw new AuthenticationException("Login of user failed.");
            }

            // generate session id
            sessionId = createSessionId();

            // store session id
            String sessionSql = "INSERT INTO public.session_store (sessionid, username) "
                    + "VALUES(?, ?)";

            PreparedStatement ps1 = jdbcAuth.prepareStatement(sessionSql);
            ps1.setString(1, sessionId);
            ps1.setString(2, userName);
            ps1.execute();

            // set user last login date
            String lastLoginSql = "UPDATE public.users SET lastlogin=timezone('utc'::text, now()) "
                    + "WHERE username ILIKE ? and enabled=true and password=sha256g(?)";
            PreparedStatement ps2 = jdbcAuth.prepareStatement(lastLoginSql);
            ps2.setString(1, userName);
            ps2.setString(2, userPass);
            ps2.executeUpdate();

            System.out.println("Authenticating " + userName + "... successful!");

        } catch (Exception e) {
            System.out.println("Authenticating " + userName + "... failed!");
            e.printStackTrace();
            throw e;
        } finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
                jdbcAuth = null;
            }
        }
        return sessionId;
    }

    /**
     * Logs out a user from the current session. This will either update the expires
     * timestamp from table session_store or remove it completely.
     *
     * @param sessionId
     * @param remove
     * @return
     * @throws Exception
     */
    public static boolean destroySession(String sessionId, boolean remove) throws Exception {
        JDBCConnectionJNDI jdbcMeta = null;
        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            String sql = "UPDATE session_store SET expires=timezone('utc'::text, now()) WHERE sessionid=?;";
            if (remove) {
                sql = "DELETE FROM session_store WHERE sessionid = ?;";
            }

            PreparedStatement ps = jdbcMeta.prepareStatement(sql);
            ps.setString(1, sessionId);

            ps.execute();

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(
                    "Removing session id " + sessionId + " from session store failed. Expiring session anyway.");
        } finally {
            jdbcMeta.closeAll();
        }
        return true;
    }

    /**
     * Looks up a session id in the session store and updates the session expires
     * timestamp.
     *
     * @param sessionid
     * @return
     * @throws Exception
     */
    public static UserCredentials getAndRenewLoggedInUser(String sessionid) throws Exception {

        System.out.println("Checking provided session id " + sessionid + ".");

        if (sessionid == null) {
            return null;
        }

        JDBCConnectionJNDI jdbcMeta = null;
        ResultSet rs = null;
        int sessionLength = 20; // minutes
        try {

            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");

            String sql = "SELECT * FROM session_store WHERE sessionid=? "
                    + "AND expires>timezone('utc'::text, now())";

            PreparedStatement ps = jdbcMeta.prepareStatement(sql);
            ps.setString(1, sessionid);

            rs = ps.executeQuery();

            if (!rs.next()) {
                return null;
            }

            UserCredentials credentials = new UserCredentials();
            credentials.setUserCredentials(rs.getString("username"), "");

            String sql2 = "UPDATE session_store SET expires=timezone('utc'::text, "
                    + "(now() + ((" + String.valueOf(sessionLength) + " || ' minutes'::text))::interval)) "
                    + "WHERE sessionid='" + sessionid + "'";
            jdbcMeta.execute(sql2);

            return credentials;
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("Look up for session id " + sessionid + " failed. Session id not valid.");
        } finally {
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
            }
        }
        return null;
    }

    private static String createSessionId() { return RandomStringUtils.randomAlphanumeric(32); }

    public static void main(String[] args) throws Exception {

    }
}
