package de.narimo.georepo.server;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.ServletContext;

import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.georepo.server.api.LayerController;
import de.narimo.georepo.server.db.PostgisInput;
import de.narimo.georepo.server.geoserver.GeoserverPostgisLayer;
import de.narimo.georepo.server.tools.QueryCheck;

public class GeorepoLayer {

	//	private String layerId;

	//	public static String georepoDatasourcePrefix = "gd_";

	/**
	 * Setting up a new georepo geoserver layer with postgis source.
	 * TODO: setup a users workspace / directory before, if it does not yet exist; separately!!
	 *
	 * @param inputFile
	 * @param fileType
	 * @param layerTitle
	 * @param SRID
	 * @param csvDelimiter
	 * @param userId
	 * @throws Exception
	 */
	public String create(
			ServletContext context,
			String absFileName,
			String fileType,
			String layerTitle,
			int SRID,
			String csvDelimiter,
			String workspace,
			boolean transactionSupport,
			String geoserverDataDir,
			String[] optColumnTypes)
            throws IOException {


		String tablePrefix = GeorepoDatasource.georepoDatasourcePrefix; //"gd_"; //naming for data tables in georepo_data db; add autoincrement index from meta table
		String tableName = "";
		//		String layerName = null;
		int layerId = -1;

		JDBCConnectionJNDI jdbcData = null;
		JDBCConnectionJNDI jdbcMeta = null;
		ResultSet rs = null;

		try{

			jdbcData = new JDBCConnectionJNDI("jdbc/georepoDataResource");
			jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

			jdbcData.setAutoCommit(false);
			jdbcMeta.setAutoCommit(false);

			String featureTypePlaceholder = ""; //GeorepoTools.normalize(layerTitle);

			//1) create entry in datasets meta table and return new created layer id
			StringBuffer sqlBuf = new StringBuffer();
			//			sqlBuf.append("INSERT INTO datasets (workspace, layer, fileType, srid, filename) ");
			//			sqlBuf.append(" VALUES ('"+userId+"', '"+readableLayerName+"', '"+fileType+"', '"+SRID+"', '"+new File(absFileName).getName()+"') RETURNING id;");
			sqlBuf.append("INSERT INTO datasets (workspace, featuretype, layer, fileType, srid, filename, inserted) ");
            sqlBuf.append(" VALUES (?, ?, ?, ?, ?, ?, timezone('utc'::text, now())) RETURNING id;");
			System.out.println(sqlBuf.toString());

            PreparedStatement ps = jdbcMeta.prepareStatement(sqlBuf.toString());
            ps.setString(1, workspace);
            ps.setString(2, featureTypePlaceholder);
            ps.setString(3, layerTitle);
            ps.setString(4, fileType);
            ps.setInt(5, SRID);
            ps.setString(6, new File(absFileName).getName());
            rs = ps.executeQuery();

			//			int layerId = -1;
			while(rs.next()){
				layerId = rs.getInt("id");
			}

			//TODO: remove, just for testing
			//			layerId = 24;

			tableName = tablePrefix+layerId;

			//2) create layer table in postgis
			if(fileType.equals("csv")){
				char delimiter = csvDelimiter.charAt(0);
				//				PostgisInput.csv2postgis(jdbcData, absFileName, tableName, delimiter, userId, geoserverDataDir, SRID);
				PostgisInput.csv2postgis(jdbcData, absFileName, tableName, delimiter, geoserverDataDir, SRID, optColumnTypes);
			}else if(fileType.equals("shp")){
				//TODO
				//				PostgisInput.shp2postgis(fileName, tableName, userId, SRID);
			}

			//optimise geometry table
			PostgisInput.optimize(jdbcData, tableName, null);

			jdbcData.commit();
			jdbcMeta.commit();

			//create layer id to reference layer
			//			this.layerId = tableName;
			//			layerName = tableName;

		}catch(Exception e){
			e.printStackTrace();

            try {
                jdbcData.rollback();
                jdbcMeta.rollback();
            } catch (SQLException se) {
            }
			throw new IOException("Could not create datasource.");
		}finally{
			if(jdbcData!=null){
				jdbcData.closeAll();
				jdbcData=null;
			}
			if(jdbcMeta!=null){
				jdbcMeta.closeAll();
				jdbcMeta=null;
			}
		}

		/*Do VACUUM within own transaction*/
		JDBCConnectionJNDI jdbcDataV = null;
		try{

			jdbcDataV = new JDBCConnectionJNDI("jdbc/georepoDataResource");
			jdbcDataV.setAutoCommit(true); //allow VACUUM to run in no transaction

			/*Do optimisation of new geometry table*/
			PostgisInput.vacuum(jdbcDataV, tableName);

		}catch(Exception e){
			e.printStackTrace();
			System.out.println("VACUUM "+tableName+" failed.");
		}finally{
			if(jdbcDataV!=null){
				jdbcDataV.closeAll();
				jdbcDataV=null;
			}
		}

		/*DO geoserver stuff*/

		//geoserver is not yet set up
		//		if(true) return;

		//3) create geoserver layer
		//user always has a workspace!! this is the same as his upload dir name (is this true??)
		//still, it has to be created as a geoserver workspace
		//		String workspace = "2616";
		//		String workspace = userWorkspace;
		//NOTE: datasource, layerName and featureType has to be the same currently
		//Is this a common restriction or might we decline from that?
		//		String datasource = "pg"; //chosen by user or internal??
		//		String datasource = tableName;

		GeoserverPostgisLayer gsrvPgLayer = new GeoserverPostgisLayer(context);

		if(!gsrvPgLayer.workspaceExists(gsrvPgLayer.getWorkspacesXML(), workspace)){

			throw new IOException("Workspace "+workspace+" does not exist.");

			//			GeoserverWorkspace wrkspc = new GeoserverWorkspace(
			//					gsrvPgLayer.getGeoserverRestUrl(),
			//					gsrvPgLayer.getHeaders(),
			//					gsrvPgLayer.getGeoserverUser(),
			//					gsrvPgLayer.getGeoserverPass());
			////			wrkspc.create(workspace);
			//			wrkspc.createNamespace(workspace); //auto-creates workspace too
			//
			//			//TODO: transaction support should be default??
			//			if(!transactionSupport) wrkspc.setTransactional(false, workspace);
			////			gsrvPgLayer.createGeoserverWorkspace(workspace);
			//
			//			//Feature does not exist in GeoServer API currently
			////			wrkspc.modifyWorkspaceSettings(workspace);
			//
			//			throw new OperationNotSupportedException("New workspace "+workspace+" has been created but cannot be activated. "
			//					+ "Please go to admin interface and enable this workspace services.");
		}

		gsrvPgLayer.setDbUserName(context.getInitParameter("dbUserLogin"));
		gsrvPgLayer.setDbUserPass(context.getInitParameter("dbUserPass"));

		//note: layer name may not be used before, has to be unique all over geoserver
		//so we use a unique layer name (which is the postgis table name)
		//and give it a readable alias
		//		String featureType = gsrvPgLayer.createNewLayer(workspace, datasource, layerTitle);
		String featureType = gsrvPgLayer.createNewLayer(workspace, layerTitle, tableName);

		try{

			jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

			String sql = "UPDATE datasets SET featuretype='"+featureType+"' WHERE id="+layerId+";";
			System.out.println(sql);
			jdbcMeta.execute(sql);

		}catch(Exception e){
			e.printStackTrace();
			System.out.println("Updating feature type "+featureType+" failed.");
		}finally{
			if(jdbcMeta!=null){
				jdbcMeta.closeAll();
				jdbcMeta=null;
			}
		}

		return featureType;
	}


	/**
	 * Replaces content of a postgis datasource/ table with new content.
	 * This operation is not incremental but discards all objects and fills the layer from scratch.
	 *
	 * @param context
	 * @param absFileName
	 * @param fileType
	 * @param layerTitle
	 * @param SRID
	 * @param csvDelimiter
	 * @param workspace
	 * @param transactionSupport
	 * @param geoserverDataDir
	 * @param optColumnTypes
	 * @param layerId
	 * @return
	 * @throws Exception
	 */
	public static String replaceLayer(
			ServletContext context,
			String absFileName,
			int SRID,
			String csvDelimiter,
			String[] optColumnTypes,
			int layerId)
					throws Exception{

		String tablePrefix = GeorepoDatasource.georepoDatasourcePrefix; //"gd_"; //naming for data tables in georepo_data db; add autoincrement index from meta table
		String tableNameNew = "";
		String tableNameCurrent = "";

		JDBCConnectionJNDI jdbcData = null;
		JDBCConnectionJNDI jdbcMeta = null;

		// 6.3) replace table with tmp table inside transaction, which could be rolled back safely

		//		see http://dba.stackexchange.com/questions/100779/how-to-atomically-replace-table-data-in-postgresql
		//		BEGIN;
		//
		//		-- The ALTER TABLE ... RENAME TO command takes an Access Exclusive lock on "table",
		//		-- but these final few statements should be fast.
		//		ALTER TABLE "table" RENAME TO "table_old";
		//		ALTER TABLE "table_new" RENAME TO "table";
		//		DROP TABLE "table_old";
		//
		//		COMMIT;


		try{

			jdbcData = new JDBCConnectionJNDI("jdbc/georepoDataResource");
			//			jdbcData.setAutoCommit(false);

			//			System.out.println("Autocommit mode: "+jdbcData.getAutoCommit());
			//			System.out.println("Connection "+jdbcData.getConnectionId()+" is closed: "+jdbcData.isClosed());
			//			jdbcData.setAutoCommit(false);


			tableNameCurrent = tablePrefix+layerId;
			tableNameNew = tableNameCurrent+"_tmp";

			String fileType = GeorepoTools.getFileExtension(absFileName);

			String geoserverDataDir = context.getInitParameter(LayerController.geoserverDataDir);

			//2) create layer table in postgis
			if(fileType.equals("csv")){
				char delimiter = csvDelimiter.charAt(0);
				PostgisInput.csv2postgis(jdbcData, absFileName, tableNameNew, delimiter, geoserverDataDir, SRID, optColumnTypes);
			}else if(fileType.equals("shp")){
				//TODO
				//				PostgisInput.shp2postgis(fileName, tableName, userId, SRID);
			}

			//			//optimise geometry table
			//			PostgisInput.optimise(jdbcData, datasourceNameNew, null);

			//			jdbcData.commit();

		}catch(Exception e){
			//			System.out.println("Could not update datasource "+tableNameNew+". Current connection id: "+jdbcData.getConnectionId());
			e.printStackTrace();
			//			jdbcData.rollback();
			throw new Exception("Could not update datasource "+tableNameNew+".");
		}finally{

			if(jdbcData!=null){
				jdbcData.closeAll(); //is null on first application call?!?!?
				jdbcData=null;
			}
		}

		/*Do VACUUM within own transaction*/
		JDBCConnectionJNDI jdbcDataV = null;
		try{

			jdbcDataV = new JDBCConnectionJNDI("jdbc/georepoDataResource");
			jdbcDataV.setAutoCommit(true); //does this help against "VACUUM cannot run inside transaction block"??

			/*Do optimisation of new geometry table*/
			PostgisInput.vacuum(jdbcDataV, tableNameNew);

		}catch(Exception e){
			e.printStackTrace();
			System.out.println("VACUUM "+tableNameNew+" failed.");
		}finally{
			if(jdbcDataV!=null){
				jdbcDataV.closeAll();
				jdbcDataV=null;
			}

		}

		try{

            QueryCheck.checkTableName(tableNameCurrent);
            QueryCheck.checkTableName(tableNameNew);

			jdbcData = new JDBCConnectionJNDI("jdbc/georepoDataResource");

			jdbcData.setAutoCommit(false);

			String oldTableName = (tableNameCurrent+"_old");

			StringBuilder sqlBuf = new StringBuilder();
			sqlBuf.append("ALTER TABLE IF EXISTS "+tableNameCurrent+" RENAME TO "+oldTableName+";");
			System.out.println(sqlBuf.toString());
			jdbcData.execute(sqlBuf.toString());

			//			jdbcData.commit();

			sqlBuf = new StringBuilder();
			sqlBuf.append("ALTER TABLE "+tableNameNew+" RENAME TO "+tableNameCurrent+";");
			System.out.println(sqlBuf.toString());
			jdbcData.execute(sqlBuf.toString());

			sqlBuf = new StringBuilder();
			sqlBuf.append("DROP TABLE IF EXISTS "+oldTableName+";");
			System.out.println(sqlBuf.toString());
			jdbcData.execute(sqlBuf.toString());

			//optimise geometry table
			PostgisInput.optimize(jdbcData, tableNameCurrent, null);

			jdbcData.commit();


			jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

            String sql = "UPDATE datasets SET filename=?, lastupdated=timezone('utc'::text, now()) WHERE id=?;";
			System.out.println(sql);

            PreparedStatement ps = jdbcMeta.prepareStatement(sql);
            ps.setString(1, new File(absFileName).getName());
            ps.setInt(2, layerId);

            ps.execute();

		}catch(Exception e){
			e.printStackTrace();
			jdbcData.rollback();
			System.out.println("Replacing "+tableNameCurrent+" with "+tableNameNew+" failed.");
		}finally{
			if(jdbcData!=null){
				jdbcData.closeAll();
				jdbcData=null;
			}
			if(jdbcMeta!=null){
				jdbcMeta.closeAll();
				jdbcMeta=null;
			}
		}


		//		try{
		//
		//			jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");
		//
		//			String sql = "UPDATE datasets SET filename='"+new File(absFileName).getName()+"', lastupdated=timezone('utc'::text, now()) WHERE id="+layerId+";";
		//			System.out.println(sql);
		//			jdbcMeta.execute(sql);
		//
		//		}catch(Exception e){
		//			e.printStackTrace();
		//			System.out.println("Updating datasets meta table failed.");
		//		}finally{
		//			if(jdbcMeta!=null){
		//				jdbcMeta.closeAll();
		//				jdbcMeta=null;
		//			}
		//
		//		}


		return tableNameNew;
	}
}
