package de.narimo.georepo.server.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.GeorepoFeatureType;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.commons.json.JsonConverter;
import de.narimo.georepo.server.GeorepoDatasource;
import de.narimo.georepo.server.GeorepoFeature;
import de.narimo.georepo.server.db.PostgisInput;
import de.narimo.georepo.server.dto.FeatureType;
import de.narimo.georepo.server.geoserver.GeoserverLayer;
import de.narimo.georepo.server.geoserver.GeoserverWorkspace;
import io.swagger.annotations.Api;

@Provider
@Path("/workspaces/{workspace}")
@Api(value = "ImportController")
public class ImportController {

    @POST
    @Path("/upload")
    public static Response upload() {
        PostgisInput.uploadFile();
        return Response.ok().build();
    }

    @POST
    @Path("/import")
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    public static Response importFile(
            @Context SecurityContext sec,
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace,

            @FormParam("filename") String fileName,
            @FormParam("layername") String layerName,
            @FormParam("columntypes") String optColumnTypes

    ) throws Exception {

        URL fp = null;

        try {
            importFile0(sec, ctx, workspace, fileName, layerName, optColumnTypes);
            fp = ImportController.class.getResource("found.html");
        } catch (Exception e) {
            e.printStackTrace();
            fp = ImportController.class.getResource("error.html");
        }

        if (fp == null) {
            throw new FileNotFoundException("found.html");
        }
        File found = new File(fp.getFile());
        return Response.ok().entity(found).build();

    }

    /**
     * Returns all feature types of a given workspace, together with additional
     * information.
     *
     * @return
     * @throws Exception
     */
    @Deprecated
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/featuretypes")
    public static Response getFeatureTypes(
            @Context SecurityContext sec,
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace) throws Exception {

        List<GeorepoFeatureType> featureTypes = new ArrayList<GeorepoFeatureType>();
        JDBCConnectionJNDI jdbcMeta = null;
        ResultSet rs = null;

        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

            GeoserverLayer layer = new GeoserverLayer(ctx);
            GeorepoFeature f = new GeorepoFeature(
                    layer.getGeoserverUrl(),
                    layer.getHeaders(),
                    layer.getGeoserverUser(),
                    layer.getGeoserverPass());

            GeoserverWorkspace wrkspc = new GeoserverWorkspace(
                    layer.getGeoserverRestUrl(),
                    layer.getHeaders(),
                    layer.getGeoserverUser(),
                    layer.getGeoserverPass());

            List<String> datasources = wrkspc.getDatasources(workspace);

            for (String d : datasources) {

                try {

                    System.out.println("\n\nDatasource: " + d);

                    List<FeatureType> ftl1 = f.getFeatureTypes(layer.getGeoserverRestUrl(), workspace, d);

                    for (FeatureType ft : ftl1) {
                        System.out.println("FeatureType: " + ft.getName());

                        String ftName = ft.getName();

                        GeorepoFeatureType featureType = new GeorepoFeatureType();
                        featureType.setName(ftName);
                        featureType.setDatasourceName(d);

                        if (!d.startsWith(GeorepoDatasource.georepoDatasourcePrefix)) {
                            throw new IllegalArgumentException("Datasource " + d + " does not contain correct prefix.");
                            // Integer layerId =
                            // Integer.valueOf(d.split(GeorepoLayer.georepoDatasourcePrefix)[1]);
                        }

                        Integer layerId = -1;
                        String[] ft_parts = ftName.split("_");
                        try {
                            layerId = Integer.valueOf(ft_parts[ft_parts.length - 1]);
                        } catch (NumberFormatException nfe) {
                            continue;
                        }

                        if (layerId < 1) {
                            continue;
                        }

                        String sql = "SELECT layer, lastupdated from datasets WHERE id=?;";
                        System.out.println(sql);

                        PreparedStatement ps = jdbcMeta.prepareStatement(sql);
                        ps.setInt(1, layerId);

                        rs = ps.executeQuery();
                        String lastUpdated = "-";
                        String layerTitle = "-";
                        if (rs.next()) {
                            layerTitle = rs.getString("layer");
                            lastUpdated = rs.getString("lastupdated");
                        }

                        featureType.setLastUpdated(lastUpdated);
                        featureType.setLayerTitle(layerTitle);
                        featureType.setLayerId(layerId);

                        featureTypes.add(featureType);
                    }

                    // }

                } catch (Exception e) {
                    System.out.println("Cannot fetch layer name for datasource " + d + " on workspace " + workspace
                            + ". Continue with next layer...");
                    e.printStackTrace();
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
                jdbcMeta = null;
            }
        }

        return Response.ok().entity(JsonConverter.toJson(featureTypes)).build();
    }

    public static void importFile0(SecurityContext sec, ServletContext ctx, String workspace, String fileName,
            String layerName, String optColumnTypes) throws Exception {

        String epsg = "4326"; // currently expected to be wgs84
        String csvDelimiter = ";";

        String fileType = "";
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        System.out.println("importing: " + fileName);
        System.out.println("fileextension: " + fileExt);
        if (fileExt.equals("csv")) {
            fileType = "geocsv";
        }

        LayerController.createLayer(sec, ctx, workspace, epsg, csvDelimiter, fileName, layerName, fileType,
                optColumnTypes);
    }
}
