package de.narimo.georepo.server.api;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.geocore.ws.login.LoginProvider;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.repository.WorkspaceRepository;

@Provider
@Path("")
public class SessionController {

    /**
     * Returns a session cookie for a user that was successfully authenticated.
     *
     * If we came here, we must assume, we are already successfully
     * authenticated.
     * This happens in a previously executed filter.
     *
     * @param createSession
     * @param sec
     * @param uriinfo
     * @param ctx
     * @param request
     * @return
     */
    @GET
    @Path("/login")
    @Produces("application/json")
    public static Response login(
            // createSession is a mandatory param! Will be evaluated by auth
            // filter and must be 'true'
            @QueryParam("sess") Boolean createSession,
            @QueryParam("workspace") String workspace,
            @Context SecurityContext sec,
            @Context UriInfo uriinfo,
            @Context ServletContext ctx,
            @Context HttpServletRequest request) {

        int userId = UserRepository.getUserId(sec.getUserPrincipal().getName());
        String permissionType = WorkspaceRepository.getWorkspacePermissionType(userId, workspace);

        return LoginProvider.createLoginResponse(ctx, request,
                sec.getUserPrincipal().getName(), permissionType);
    }

    /**
     * Returns an empty session cookie after session destroy.
     *
     * @param sec
     * @param uriinfo
     * @param request
     * @return
     */
    @POST
    @Path("/logout")
    public static Response logout(
            @Context SecurityContext sec,
            @Context UriInfo uriinfo,
            @Context HttpServletRequest request) {

        return LoginProvider.createLogoutResponse(request, "georepo-server");
    }
}
