package de.narimo.georepo.server.tools;

import java.io.IOException;

import org.apache.commons.lang3.StringUtils;

public class QueryCheck {

    public static void checkTableName(String tableName) throws IOException {
        if (tableName == null || tableName.isEmpty() || StringUtils.containsWhitespace(tableName) || tableName.contains(";")) {
            throw new IOException("Table name " + tableName + " is not supported as a table name.");
        }
    }

    public static void checkDiffTableName(String tableName) throws IOException {
        if (tableName == null || tableName.isEmpty() || !tableName.contains("_diff")) {
            throw new IOException("Table name " + tableName + " is not supported as a diff table name.");
        }
    }
}
