package de.narimo.georepo.server.api;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.ws.http.HTTPProxy;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.georepo.server.http.GeoserverHTTPProxy;
import io.swagger.annotations.Api;

/**
 * This class pipes all workspace related requests directly to geoserver acting
 * as a proxy.
 *
 * @author Ulrich Mann
 *
 */
@Provider
@Path("/workspaces/{workspace}/ows/{owsType}")
@Api(value = "GeoserverProxyController")
public class GeoserverProxyController {

    //////////////////////
    // WMS, WFS, WCS
    /////////////////////

    @GET
    @Path("/")
    public static Response pipeGET(
            @PathParam("workspace") String workspace,
            @PathParam("owsType") String owsType,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest) throws Exception {
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    @OPTIONS
    @Path("/")
    public static Response pipeOPTIONS(
            @PathParam("workspace") String workspace,
            @PathParam("owsType") String owsType,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest) throws Exception {
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    @PUT
    @Path("/")
    public static Response pipePUT(
            @PathParam("workspace") String workspace,
            @PathParam("owsType") String owsType,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @POST
    @Path("/")
    public static Response pipePOST(
            @PathParam("workspace") String workspace,
            @PathParam("owsType") String owsType,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @DELETE
    @Path("/")
    public static Response pipeDELETE(
            @PathParam("workspace") String workspace,
            @PathParam("owsType") String owsType,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    public static Response pipeRequest(
            String workspace,
            String owsType,
            ServletContext ctx,
            UriInfo uriinfo,
            HttpHeaders httpHeaders,
            HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {

        String wsUrl = ctx.getInitParameter("geoserverUrl") + "/" + workspace + "/" + owsType + "?";
        Response response = GeoserverHTTPProxy.pipe(
                wsUrl,
                uriinfo,
                httpHeaders,
                null,
                HttpMethod.getHttpMethod(httpServletRequest.getMethod()));

        // Jersey will set another Transfer-Encoding or Content-Length header on
        // outgoing response,
        // which will interfere and cause the client to not understand the
        // response, so we omit the originally set Transfer-Encoding=chunked
        // see:
        // http://stackoverflow.com/questions/35831003/prevent-jersey-from-setting-content-length-header-if-transfer-encoding-is-alread
        HTTPProxy.removeHeader(response.getStringHeaders(), "Transfer-Encoding");
        return response;
    }

    public static void main(String[] args) throws Exception {
        String value = "text/xml; subtype=gml/3.4";
        value = value.replace("subtype=gml/", "subtype=\"gml/");
        // value.replace("subtype=gml", "bla");
        // value.replace("subtype=gml", "subtype=\"gml");.r
        value += "\"";

        System.out.println("value: " + value);
    }
}
