package de.narimo.georepo.server.filter;

import java.io.IOException;
import java.sql.PreparedStatement;

import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.jdbc.JDBCConnectionJNDI;

@Provider
@Priority(Priorities.USER)
public class OWSAccessLoggingFilter implements ContainerRequestFilter {

    @Context
    private HttpServletRequest httpServletRequest;

    @Context
    private SecurityContext sec;

    @Context
    private UriInfo uriInfo;

    @Override
    public void filter(ContainerRequestContext crc) throws IOException {

        String ipz = this.httpServletRequest.getRemoteAddr();

        try {

            // intermediate proxy ips
            String ips = this.httpServletRequest.getHeader("X-Forwarded-For");

            // original client ip
            ipz = ips.split(",")[0];

        } catch (Exception ignored) {
        }

        if (ipz == null) {
            ipz = this.httpServletRequest.getRemoteAddr();
        }

        String ip = ipz;

        String userAgent = this.httpServletRequest.getHeader("user-agent");

        String serviceTypez = this.uriInfo.getQueryParameters().getFirst("SERVICE");
        final String serviceType = serviceTypez == null ? this.uriInfo.getQueryParameters().getFirst("service")
                : serviceTypez;

        String requestz = this.uriInfo.getQueryParameters().getFirst("REQUEST");
        final String request = requestz == null ? this.uriInfo.getQueryParameters().getFirst("request") : requestz;

        String pxWidthz = this.uriInfo.getQueryParameters().getFirst("WIDTH");
        final String pxWidth = pxWidthz == null ? this.uriInfo.getQueryParameters().getFirst("width") : pxWidthz;

        String pxHeightz = this.uriInfo.getQueryParameters().getFirst("HEIGHT");
        final String pxHeight = pxHeightz == null ? this.uriInfo.getQueryParameters().getFirst("height") : pxHeightz;

        String params = this.uriInfo.getRequestUri().toString();

        String requestedUrl = this.httpServletRequest.getRequestURL().toString();
        String workspace = requestedUrl.split("/")[4];

        String user = this.sec.getUserPrincipal().getName();

        // separate task to not interfere with request run-time
        Runnable r = new Runnable() {
            @Override
            public void run() {

                JDBCConnectionJNDI jdbcData = null;

                try {

                    // IP | user | workspace | servicetype | useragent | pxwidth
                    // | pxheight | params

                    jdbcData = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

                    // log full query details (will be removed from table after
                    // certain amount of time
                    String query = "INSERT INTO owsaccesslog (ip, username, workspace, servicetype, request, pxwidth, pxheight, params, useragent) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
                    PreparedStatement ps = jdbcData.prepareStatement(query);
                    ps.setString(1, ip);
                    ps.setString(2, user);
                    ps.setString(3, workspace);
                    ps.setString(4, serviceType);
                    ps.setString(5, request);
                    ps.setString(6, pxWidth);
                    ps.setString(7, pxHeight);
                    ps.setString(8, params);
                    ps.setString(9, userAgent);
                    ps.execute();

                } catch (Exception e) {
                    e.printStackTrace();

                } finally {
                    if (jdbcData != null) {
                        jdbcData.closeAll();
                    }
                }
            }
        };

        new Thread(r).start();

    }

}
