package de.narimo.georepo.server.geoserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;

public class GeoserverLayer {

    String dbUserName;
    String dbUserPass;
    String dbSchema = "public";
    String pgPort;

    private String geoserverUrl;
    private String geoserverRestUrl;
    private String geoserverUser;
    private String geoserverPass;

    private Map<String, String> headers = new HashMap<String, String>();

    public GeoserverLayer(ServletContext ctx) {

        this.geoserverUrl = ctx.getInitParameter("geoserverUrl");
        this.geoserverRestUrl = ctx.getInitParameter("geoserverRestUrl");
        this.geoserverUser = ctx.getInitParameter("geoserverUser");
        this.geoserverPass = ctx.getInitParameter("geoserverPass");
        this.pgPort = ctx.getInitParameter("postgresPort");
        this.headers.put("Content-Type", "application/xml");
    }

    /**
     * Determines, whether a layername already exists on the geoserver instance.
     * Actually, we would need to check if layer exists in a workspace, because
     * therein layers have to be unique.
     *
     * @return
     */
    public boolean layerExists(String layerTitle) throws IOException {

        // TODO: check for normalized name, i.e. feature type??
        // check if the layername already exists on geoserver
        // if so, we create the layer with a different alias
        String layersXML = this.getLayersXML();

        if (layersXML == null) {
            throw new IOException("Layers XML is not defined.");
        }
        if (layerTitle == null) {
            throw new IOException("Missing value layerName.");
        }

        if (layersXML.contains("<name>" + layerTitle + "</name>")) {
            return true;
            // if(layersXML.contains("<title>"+layerTitle+"</title>")) return
            // true;
        }

        return false;
    }

    /**
     * Check, whether a datasource with given name already exists in the
     * workspace.
     *
     * @param workspace
     * @param datasource
     * @return
     * @throws Exception
     */
    public boolean datasourceExists(String datasourcesXML, String datasource) throws IOException {
        return this.sourceExists(datasourcesXML, datasource);
    }

    public boolean wmsstoreExists(String wmsstoresXML, String wmsstore) throws IOException {
        return this.sourceExists(wmsstoresXML, wmsstore);
    }

    public boolean workspaceExists(String workspacesXML, String workspace) throws IOException {
        return this.sourceExists(workspacesXML, workspace);
    }

    private boolean sourceExists(String datasourcesXML, String datasource) throws IOException {
        if (datasourcesXML == null) {
            throw new IOException("xml source is not defined.");
        }
        if (datasource == null) {
            throw new IOException("Missing value datasource.");
        }

        if (datasourcesXML.contains("<name>" + datasource + "</name>")) {
            return true;
        }
        System.out.println("Source " + datasource + " does not exists in datasourcesXML.");
        return false;
    }

    /**
     * Get vector datasources that exist in the given workspace.
     *
     * @param workspace
     * @param datasource
     * @throws Exception
     */
    public String getDatasourcesXML(String workspace) throws IOException {
        URLResponse rr = HttpURLClient.sendRequest(
                this.geoserverRestUrl + "/workspaces/" + workspace + "/datastores.xml", null, null, null,
                HttpMethod.GET, null, this.geoserverUser, this.geoserverPass, false, false);

        String datasourcesXML = rr.getResponseBody();

        return datasourcesXML;
    }

    private String getWMSStoresXML(String workspace, String wmsstore) throws IOException {
        if (wmsstore == null) {
            throw new IOException("Missing value datasource.");
        }

        URLResponse rr = HttpURLClient.sendRequest(this.geoserverRestUrl + "/workspaces/" + workspace + "/wmsstores.xml", null,
                null, null, HttpMethod.GET, null, this.geoserverUser, this.geoserverPass, false, false);

        String wmsstoresXML = rr.getResponseBody();

        return wmsstoresXML;
    }

    public String getWorkspacesXML() throws IOException {
        URLResponse rr = null;
        try {
            rr = HttpURLClient.sendRequest(this.geoserverRestUrl + "/workspaces.xml", null, null, null,
                    HttpMethod.GET, null, this.geoserverUser, this.geoserverPass, false, false);
        } catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        String workspacesXML = rr.getResponseBody();

        return workspacesXML;
    }

    /**
     * Get existing layers on this geoserver over all workspaces.
     *
     * @throws Exception
     */
    public String getLayersXML() throws IOException {

        URLResponse rr = HttpURLClient.sendRequest(this.geoserverRestUrl + "/layers.xml", null, null, null,
                HttpMethod.GET, null, this.geoserverUser, this.geoserverPass, false, false);

        String layersXML = rr.getResponseBody();
        return layersXML;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public void setDbUserName(String dbUserName) {
        this.dbUserName = dbUserName;
    }

    public String getDbUserPass() {
        return this.dbUserPass;
    }

    public void setDbUserPass(String dbUserPass) {
        this.dbUserPass = dbUserPass;
    }

    public String getGeoserverUser() {
        return this.geoserverUser;
    }

    public String getGeoserverPass() {
        return this.geoserverPass;
    }

    public String getGeoserverUrl() {
        return this.geoserverUrl;
    }

    public String getGeoserverRestUrl() {
        return this.geoserverRestUrl;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public String getPgPort() {
        return this.pgPort;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}
