/*create meta database*/
CREATE DATABASE georepo_meta WITH OWNER georepo_admin ENCODING 'UTF8';

/*create datasets table holding user layers*/
CREATE TABLE datasets(
	id serial PRIMARY KEY NOT NULL,
	workspace varchar (10) NOT NULL,
	featureType varchar (100) NOT NULL DEFAULT '-'::text,
	layer varchar (100) NOT NULL,
	fileType varchar (10) NOT NULL,
	srid varchar (10) NOT NULL DEFAULT 4326,
	filename varchar (100),
	inserted timestamp(0) with time zone NOT NULL,
	lastUpdated timestamp(0) with time zone NOT NULL DEFAULT timezone('utc'::text, now())
);

/*if created from postgres user*/
ALTER TABLE datasets
  OWNER TO georepo_admin;

/*command line creation*/
-- CREATE TABLE datasets(id serial PRIMARY KEY NOT NULL,	userId INT NOT NULL, layer varchar (100) NOT NULL, fileType varchar (10) NOT NULL,	srid varchar (10) NOT NULL DEFAULT 4326, filename varchar (100));