package de.narimo.georepo.server.tools;

import javax.ws.rs.ForbiddenException;

import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.repository.WorkspaceRepository;

public class AdminTools {

    /**
     * Check if user has admin permissions for the workspace.
     *
     * @throws ForbiddenException
     *             in case of missing admin permission for the workspace
     */
    public static void checkAdminPermission(int userId, String workspace) throws ForbiddenException {
        int workspaceCount = WorkspaceRepository.getWorkspaceCount(userId, workspace, "a");
        if (workspaceCount < 1) {
            throw new ForbiddenException("Unsufficient permissions for this operation.");
        }
    }

    public static void checkCanCreateWorkspace(int userId) throws ForbiddenException {
        if (!UserRepository.canUserCreateWorkspace(userId)) {
            throw new ForbiddenException("No permissions to create workspace.");
        }
    }
}
