package de.narimo.georepo.server.tools;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class GeometryTools {

    /**
     * Create a single point geometry instance.
     *
     * @param x
     * @param y
     * @param gf
     * @return
     */
    public static Geometry createPointGeometry(double x, double y, GeometryFactory gf) {
        Coordinate coordinate = new Coordinate(x, y);
        Point point = gf.createPoint(coordinate);
        return gf.createGeometry(point);
    }
}
