package de.narimo.georepo.server.geoserver;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import javax.servlet.ServletContext;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;
import de.narimo.georepo.server.GeorepoTools;

public class GeoserverVectorLayer extends GeoserverLayer{
	
	public GeoserverVectorLayer(ServletContext ctx){
		super(ctx);
	}

	/**
	 * Create a geoserver datasource for vector data types.
	 * @param workspace
	 * @param datasourceName
	 * @param body
	 * @return
	 * @throws Exception
	 */
	public void createGeoserverDatasource0(
			String workspace,
			String datasourceName,
			String body
    ) throws IOException {
		
		if(workspace==null) throw new IOException("Missing value workspace.");
		if(datasourceName==null) throw new IOException("Missing value datasourceName.");
		
//		System.out.println("Creating vector datasource with body: "+body);
//		System.out.println("Creating vector datasource with body.");

		URLResponse rr = HttpURLClient.sendRequest(
				getGeoserverRestUrl()+"/workspaces/"+workspace+"/datastores",
				null,
				getHeaders(),
				body,
				HttpMethod.POST,
				null,
				getGeoserverUser(),
				getGeoserverPass(),
				false,
				false);
		
		if(rr.getStatusCode()!=201) throw new InternalError("Creating datasource "+datasourceName+" failed with status "+rr.getStatusCode()+". Probably it already exists.");
		
//		return datasourceName;
	}

//	public void createGeoserverFeatureType(String workspace, String datasourceName, String internalLayerName, String layerTitle) throws Exception{
    public String createGeoserverFeatureType(String workspace, String datasourceName, String tableName, String layerTitle)
            throws IOException {

		if(workspace==null) throw new IOException("Missing value workspace.");
		if(datasourceName==null) throw new IOException("Missing value datasourceName.");
		if(tableName==null) throw new IOException("Missing value tableName.");
		tableName = tableName.replace(':', '_'); //colon is reserved as workspace:layer separator
//		if(internalLayerName==null) throw new IOException("Missing value layerName.");	
//		internalLayerName = internalLayerName.replace(':', '_'); //colon is reserved as workspace:layer separator
				
		if(layerTitle==null){
//			layerTitle = internalLayerName;
			layerTitle = tableName;
		}else{
			//should be unimportant for layer title; only important in layer name
//			layerTitle = layerTitle.replace(':', '_');
		}
		
		String layerAbstract = layerTitle;
		
		//layer alias should not contain umlaute or other diacritic characters. Layer will not be able to call on geoserver
		//TODO fix this!
		String featureTypeName = GeorepoTools.normalize(layerTitle);
		
		String body = "<featureType>"+
			   "<name>"+featureTypeName+"</name>"+ //normalized layer name
			   "<nativeName>"+tableName+"</nativeName>"+ //something like gd_59
			   "<title>"+layerTitle+"</title>"+ //readable name like "hell0 worldß!###"
			   "<abstract>"+layerAbstract+"</abstract>"+
			"</featureType>";
						
		System.out.println("Creating feature type with body: "+body);
		
		URLResponse rr = HttpURLClient.sendRequest(
				getGeoserverRestUrl()+"/workspaces/"+workspace+"/datastores/"+datasourceName+"/featuretypes",
				null,
				getHeaders(),
				body,
				HttpMethod.POST,
				null,
				getGeoserverUser(),
				getGeoserverPass(),
				false,
				false);
		
		if(rr.getStatusCode()!=201) throw new InternalError("Creating featureType and layer "+featureTypeName+" failed with status "+rr.getStatusCode()+".");
		
		return featureTypeName;
	}
	
	/**
	 * Updates the bbox of the feature type after changes to underlying datasource have been made.
	 * Sets the layer to enabled.
	 * 
	 * 
	 * @param workspace
	 * @param datasourceName
	 * @param featureType
	 * @throws Exception
	 */
	public void recalculateFeatureType(String workspace, String datasourceName, String featureType) throws Exception{
		
		System.out.println("Reloading feature type...");
		
//		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm+00:00");
//		dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
//	 	String now = dateFormat.format(new Date());
		
	 	//this should be included, to show last update ts on capabilities
	 	//to do so, we must first know how to retrieve current abstract of feature type from rest api
	 	//otherwise we will overwrite current abstract
//		String layerAbstract = "Last updated: "+now;
		
		String body = "<featureType>"
				+ "<enabled>true</enabled>"
//				+ "<abstract>"+layerAbstract+"</abstract>"
				+ "</featureType>";		
		
		String featTypeEnc = URLEncoder.encode(featureType, "UTF-8");
		URLResponse rr = HttpURLClient.sendRequest(
				getGeoserverRestUrl()+"/workspaces/"+workspace+"/datastores/"+datasourceName+"/featuretypes/"+featTypeEnc+"?recalculate=nativebbox,latlonbbox",
				null,
				getHeaders(),
				body,
				HttpMethod.PUT,
				null,
				getGeoserverUser(),
				getGeoserverPass(),
				false,
				false);
		
		if(rr.getStatusCode()!=200) throw new InternalError("Recalculating featureType "+workspace+":"+featureType+" failed with status "+rr.getStatusCode()+".");
	}

	
	public static void main(String[] args){
		
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm+00:00");
		dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
	 	String now = dateFormat.format(new Date());
	 	
	 	System.out.println(now);
	}
}
