package de.narimo.georepo.server.api.account;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.narimo.commons.dto.geometa.User;
import de.narimo.geocore.ws.registration.AccountDeletionDetails;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.notification.Notifier;
import io.swagger.annotations.Api;

@Provider
@Path("/account")
@Api(value = "AccountController")
public class AccountController {

    /**
     * TODO: notify workspace admin(s) about account removal
     * 
     * @param ctx
     * @param sec
     * @param body
     * @return
     */
    @POST
    @Path("/remove")
    public static Response removeUserAccount(@Context ServletContext ctx, @Context SecurityContext sec, InputStream body) {

        try {

            String clientApp = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                AccountDeletionDetails details = mapper.readValue(body, AccountDeletionDetails.class);
                clientApp = details.getClientApp();
            } catch (JsonMappingException e) {
            }

            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();

            // disable account in database
            try {
                UserRepository.disableUser(user.getId());

                // notify narimo
                Notifier.notifyNarimoAboutAccountRemoval(ctx, user.getEmail(), clientApp);
            } catch (InternalError e) {
                Notifier.notifyNarimoAboutFailedAccountRemoval(ctx, user.getEmail(), clientApp);
            }

            // always send notification to user, even if removal failed
            Notifier.notifyAccountDeleteConfirmation(ctx, user.getEmail(), clientApp);
            return Response.ok().build();

        } catch (IOException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (InternalError | RuntimeException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}
