package de.narimo.georepo.server.filter;

import java.io.IOException;

import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(Priorities.USER)
public class ResponseFilter  implements ContainerResponseFilter{
	public void filter(ContainerRequestContext crc, ContainerResponseContext response) throws IOException{
        // prevent caching for all georepo responses
        response.getHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
        response.getHeaders().add("Pragma", "no-cache"); // HTTP 1.0.
        response.getHeaders().add("Expires", "0"); // Proxies.
	}
}
