package de.narimo.georepo.server.geoserver;

import java.io.IOException;

import javax.servlet.ServletContext;

import de.narimo.georepo.server.GeorepoDatasource;

public class GeoserverPostgisLayer extends GeoserverVectorLayer{

	public GeoserverPostgisLayer(ServletContext ctx){
		super(ctx);
	}

	/**
	 * Create a new geoserver layer in the workspace and returns the featureType.
	 *
	 * TODO: ignore the inserted datasource name!
	 *
	 * @param datasource
	 * @param layername
	 * @param externWfsUrl
	 * @throws Exception
	 */
    public String createNewLayer(String workspace, String layerTitle, String tableName) throws IOException {

		GeoserverDatasourceType datasourceType = GeoserverDatasourceType.PostGISJNDI;

		if(workspace==null)
		{
			throw new IOException("Missing value workspaceName.");
			//		if(layerTableName==null) throw new IOException("Missing value datasourceName.");
		}

		//		//check if the layername already exists on geoserver
		//		//if so, we create the layer with a different alias
		//		String layersXML = getLayersXML();

		if(this.layerExists(layerTitle)){
            throw new IOException("Layer name " + layerTitle + " already exists.");
		}

		//		String layerAliasName = layerName;
		//
		//		//check if the layername already exists on geoserver
		//		//if so, we create the layer with a different alias
		//		String layersXML = getLayersXML();
		//
		//		String tmpLayerAlias = layerAliasName;
		//
		//		int cnt=1;
		//		while(layerExists(layersXML, tmpLayerAlias)){
		//			System.out.println("layer "+tmpLayerAlias+" exists.");
		//			tmpLayerAlias = layerAliasName.concat(String.valueOf(cnt));
		//			cnt++;
		//		}
		//		System.out.println("using "+tmpLayerAlias+" as layer alias.");
		//		layerAliasName = tmpLayerAlias;

		/**
		 * @deprecated. we should use an existing datasource, if available
		 */
		//		this.createGeoserverPostgisDatasource(workspace, datasource, true);


		////////////////
		//reuse existing datasource from the workspace
		//use the first one with the relevant connection type
		GeoserverWorkspace wrkspc = new GeoserverWorkspace(
				this.getGeoserverRestUrl(),
				this.getHeaders(),
				this.getGeoserverUser(),
				this.getGeoserverPass());

		String datasource = wrkspc.getDatasource(workspace, datasourceType);
		//		if(datasource==null) throw new RuntimeException("Missing vector datasource for workspace "+workspace+". You have to create one first.");

		//or create new if not exists
		//		NOPE, must be existing!! Should be created with workspace??
		if(datasource==null){
			//			String dsName = workspace+"_jndi";
			datasource = GeorepoDatasource.georepoDatasourcePrefix+workspace;
			//			String tmpDatasourceName = dsName;
			if(!this.createGeoserverPostgisJNDIDatasource(workspace, datasource, "jdbc/georepoDataResource")){
				throw new RuntimeException("Could not create datasource "+datasource+".");
			}

			//			int cnt=1;
			//			while(!createGeoserverPostgisJNDIDatasource(workspace, tmpDatasourceName, "jdbc/georepoDataResource")){
			//
			//				System.out.println("Datasource "+tmpDatasourceName+" exists.");
			//				tmpDatasourceName = dsName.concat(String.valueOf(cnt));
			//				cnt++;
			//			}

			//			datasource = tmpDatasourceName;
		}

		return this.createGeoserverFeatureType(workspace, datasource, tableName, layerTitle);

	}

    private boolean createGeoserverPostgisJNDIDatasource(String workspace, String datasourceName, String datasourceJNDIRefName)
            throws IOException {

		if(workspace==null) {
			throw new IOException("Missing value workspace.");
		}
		if(datasourceName==null) {
			throw new IOException("Missing value datasourceName.");
		}
		if(datasourceJNDIRefName==null) {
			throw new IOException("Missing value datasourceJNDIRefName.");
		}

		//check if the datasource already exists in the workspace
		String datasourcesXML = this.getDatasourcesXML(workspace);
		if(this.datasourceExists(datasourcesXML, datasourceName)) {
			System.out.println("Datasource already exists. Cannot create.");
			return false;
		}

		String jndiRefName = "java:comp/env/"+datasourceJNDIRefName;
		String dbtype = "postgis";
		String fetchSize = "1000";
		//		String namespace = "https://data.georepo.com/georepo-server/rest/namespaces/ws5111";
		String namespace = this.getGeoserverRestUrl() + "/namespaces/" + workspace;

		String datasourceType = "PostGIS (JNDI)";
		String description = datasourceType + " datasource for workspace " + workspace;

		String body =
				"<dataStore>"+
						"<name>"+datasourceName+"</name>"+
						"<type>"+datasourceType+"</type>"+
						"<description>"+description+"</description>"+
						"<enabled>true</enabled>"+
						"<workspace>"+
						"<name>"+workspace+"</name>"+
						"</workspace>"+
						"<connectionParameters>"+
						"<entry key=\"dbtype\">"+dbtype+"</entry>"+
						"<entry key=\"encode functions\">false</entry>"+
						"<entry key=\"jndiReferenceName\">"+jndiRefName+"</entry>"+
						"<entry key=\"Support on the fly geometry simplification\">true</entry>"+
						"<entry key=\"namespace\">"+namespace+"</entry>"+
						"<entry key=\"schema\">"+this.dbSchema+"</entry>"+
						"<entry key=\"Loose bbox\">true</entry>"+
						"<entry key=\"Expose primary keys\">false</entry>"+
						"<entry key=\"fetch size\">"+fetchSize+"</entry>"+
						"<entry key=\"preparedStatements\">false</entry>"+
						"<entry key=\"Estimated extends\">true</entry>"+
						"</connectionParameters>"+
						"<__default>false</__default>"+
						"</dataStore>";


		this.createGeoserverDatasource0(workspace, datasourceName, body);
		return true;
	}
}
