package de.narimo.georepo.server.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;

import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.repository.DiffDatasetRepository;
import de.narimo.georepo.server.tools.TableTools;

public class DiffFeatureLayer {

    public static String getModifiedFeatures(int userId, String dataWorkspace, String featureType, boolean asAdmin)
            throws IOException {
        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);

        FeatureCollection featureCollection = DiffDatasetRepository.getModifiedDatasets(diffTableName, diffAuthTableName, userId,
                asAdmin);

        if (featureCollection.isEmpty()) {
            Map<String, Class> propertyTypes = new HashMap<String, Class>();
            propertyTypes.put("a", String.class);

            FeatureBuilder fb = new FeatureBuilder(propertyTypes);
            featureCollection = fb.createFeatureCollection(new ArrayList<SimpleFeature>());
        }
        return FeatureBuilder.featureCollectionToJson(featureCollection);
    }

    public static void addNewFeatures(long userId, String dataWorkspace, String featureType, List<SimpleFeature> features)
            throws IOException {

        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);
        
        DiffDatasetRepository.insertDatasets(diffTableName, diffAuthTableName, features, userId);
    }

    public static void addModifiedFeatures(int userId, String dataWorkspace, String featureType,
            List<SimpleFeature> features) throws IOException {

        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTableName = TableTools.getDiffTableName(layerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(layerId);

        DiffDatasetRepository.updateDatasets(diffTableName, diffAuthTableName, features, userId);
    }

    public static void addDeletedFeatures(int userId, String dataWorkspace, String featureType,
            List<SimpleFeature> features) throws IOException {

        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTableName = TableTools.getDiffTableName(dataLayerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(dataLayerId);
        DiffDatasetRepository.deleteDatasets(diffTableName, diffAuthTableName, features, userId);
    }

    public static void acceptFeatureChange(int grpfid, String dataWorkspace, String dataFeatureType) throws IOException {

        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace, dataFeatureType);
        String dataTable = TableTools.getDataTableName(dataLayerId);
        String diffTable = TableTools.getDiffTableName(dataLayerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(dataLayerId);

        DiffDatasetRepository.acceptDataset(diffTable, dataTable, diffAuthTableName, grpfid);
    }

    public static void declineFeatureChange(int grpfid, String dataWorkspace, String featureType) throws IOException {
        int dataLayerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String diffTable = TableTools.getDiffTableName(dataLayerId);
        String diffAuthTableName = TableTools.getDiffAuthTableName(dataLayerId);

        DiffDatasetRepository.declineDataset(diffTable, diffAuthTableName, grpfid);
    }
}
