package de.narimo.georepo.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import de.narimo.commons.http.URLResponse;
import de.narimo.commons.json.JsonConverter;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.commons.ws.http.HttpURLClient;
import de.narimo.georepo.server.dto.FeatureType;
import de.narimo.georepo.server.dto.FeatureTypes;
import de.narimo.georepo.server.dto.FeatureTypesList;

/**
 * Class representing features within a GeorepoLayer
 *
 * This class allows CRUD operations to features and thus
 * should be only allowed to use for extended api users.
 *
 * Actually, this is only a wrapper to the geoserver api.
 *
 * Would be nice feature to support add, update, delete within one <Transaction>
 * as this is atomic and will leave layer unaltered, if single operation fails
 * see
 * http://docs.geoserver.org/latest/en/user/services/wfs/reference.html#transaction
 *
 * TODO: ensure correct axis ordering when inserting feature coordinates!!
 *
 * @author Ulrich Mann
 *
 */
@Deprecated
public class GeorepoFeature {

    String geoserverUrl;
    // TODO: adapt this after geoserver has been facaded
    Map<String, String> connectionHeaders;
    String geoserverAdmin; // could that be the user login? currently the
                           // georepo users don't have access to geoserver
    String geoserverPass;

    public GeorepoFeature(String geoserverUrl, Map<String, String> connectionHeaders, String geoserverAdmin,
            String geoserverPass) {

        this.geoserverUrl = geoserverUrl;
        this.connectionHeaders = connectionHeaders;
        this.geoserverAdmin = geoserverAdmin;
        this.geoserverPass = geoserverPass;

    }

    /**
     * Can handle multiple featuretypes per datasource.
     *
     * @deprecated use GeoserverWorkspace.getWorkspaceFeatureTypes()
     *
     * @param geoserverRestUrl
     * @param workspace
     * @param datasource
     * @return
     * @throws Exception
     */
    public List<FeatureType> getFeatureTypes(String geoserverRestUrl, String workspace, String datasource)
            throws Exception {

        String url = "/workspaces/" + workspace + "/datastores/" + datasource + "/featuretypes.json";

        String body = "<featureType></featureType>";

        URLResponse rr = HttpURLClient.sendRequest(
                geoserverRestUrl + url,
                null,
                null,
                body,
                HttpMethod.GET,
                null,
                this.geoserverAdmin,
                this.geoserverPass,
                false,
                false);

        FeatureTypesList ftl = JsonConverter.fromJson(rr.getResponseBody(), FeatureTypesList.class);

        List<FeatureType> featureTypes = new ArrayList<FeatureType>();

        for (FeatureTypes fts : ftl.featureTypes) {
            for (FeatureType ft : fts.featureType) {
                featureTypes.add(ft);
            }
        }
        return featureTypes;
    }
}
