package de.narimo.georepo.server.api;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.ws.http.HTTPProxy;
import de.narimo.commons.ws.http.HttpMethod;
import de.narimo.georepo.server.http.GeoserverHTTPProxy;
import io.swagger.annotations.Api;

/**
 * This class pipes all workspace related requests directly to geoserver acting
 * as a proxy.
 *
 * @author Ulrich Mann
 *
 */
@Provider
@Path("/workspaces/{workspace}")
@Api(value = "OWSController")
public class OWSController {

    /////////
    // OWS //
    /////////

    @GET
    @Path("/ows")
    public static Response pipeOwsGET(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "ows";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @PUT
    @Path("/ows")
    public static Response pipeOwsPUT(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "ows";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @POST
    @Path("/ows")
    public static Response pipeOwsPOST(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "ows";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @DELETE
    @Path("/ows")
    public static Response pipeOwsDELETE(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "ows";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @OPTIONS
    @Path("/ows")
    public static Response pipeOWSOPTIONS(@PathParam("workspace") String workspace, @Context ServletContext ctx,
            @Context UriInfo uriinfo, @Context HttpHeaders httpHeaders, @Context HttpServletRequest httpServletRequest)
            throws Exception {
        String owsType = "ows";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    /////////
    // WMS //
    /////////

    @GET
    @Path("/wms")
    public static Response pipeWMSGET(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wms";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @PUT
    @Path("/wms")
    public static Response pipeWMSPUT(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wms";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @POST
    @Path("/wms")
    public static Response pipeWMSPOST(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wms";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @DELETE
    @Path("/wms")
    public static Response pipeWMSDELETE(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wms";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @OPTIONS
    @Path("/wms")
    public static Response pipeWMSOPTIONS(@PathParam("workspace") String workspace, @Context ServletContext ctx,
            @Context UriInfo uriinfo, @Context HttpHeaders httpHeaders, @Context HttpServletRequest httpServletRequest)
            throws Exception {
        String owsType = "wms";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    /////////
    // WFS //
    /////////

    @GET
    @Path("/wfs")
    public static Response pipeWFSGET(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wfs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @PUT
    @Path("/wfs")
    public static Response pipeWFSPUT(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wfs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @POST
    @Path("/wfs")
    public static Response pipeWFSPOST(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wfs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @DELETE
    @Path("/wfs")
    public static Response pipeWFSDELETE(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wfs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @OPTIONS
    @Path("/wfs")
    public static Response pipeWFSOPTIONS(@PathParam("workspace") String workspace, @Context ServletContext ctx,
            @Context UriInfo uriinfo, @Context HttpHeaders httpHeaders, @Context HttpServletRequest httpServletRequest)
            throws Exception {
        String owsType = "wfs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    /////////
    // WCS //
    /////////
    @GET
    @Path("/wcs")
    public static Response pipeWCSGET(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wcs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @PUT
    @Path("/wcs")
    public static Response pipeWCSPUT(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wcs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @POST
    @Path("/wcs")
    public static Response pipeWCSPOST(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wcs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @DELETE
    @Path("/wcs")
    public static Response pipeWCSDELETE(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {
        String owsType = "wcs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, body);
    }

    @OPTIONS
    @Path("/wcs")
    public static Response pipeWCSOPTIONS(
            @PathParam("workspace") String workspace,
            @Context ServletContext ctx,
            @Context UriInfo uriinfo,
            @Context HttpHeaders httpHeaders,
            @Context HttpServletRequest httpServletRequest) throws Exception {
        String owsType = "wcs";
        return pipeRequest(workspace, owsType, ctx, uriinfo, httpHeaders, httpServletRequest, null);
    }

    public static Response pipeRequest(
            String workspace,
            String owsType,
            ServletContext ctx,
            UriInfo uriinfo,
            HttpHeaders httpHeaders,
            HttpServletRequest httpServletRequest,
            byte[] body) throws Exception {

        String wsUrl = ctx.getInitParameter("geoserverUrl") + "/" + workspace + "/" + owsType + "?";
        Response response = GeoserverHTTPProxy.pipe(
                wsUrl,
                uriinfo,
                httpHeaders,
                body,
                HttpMethod.getHttpMethod(httpServletRequest.getMethod()));

        // Jersey will set another Transfer-Encoding or Content-Length header on
        // outgoing response,
        // which will interfere and cause the client to not understand the
        // response, so we omit the originally set Transfer-Encoding=chunked
        // see:
        // http://stackoverflow.com/questions/35831003/prevent-jersey-from-setting-content-length-header-if-transfer-encoding-is-alread
        HTTPProxy.removeHeader(response.getStringHeaders(), "Transfer-Encoding");
        return response;
    }
}
