package de.narimo.georepo.server.api.noauth;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.databind.ObjectMapper;

import de.narimo.commons.dto.geometa.User;
import de.narimo.geocore.ws.registration.PasswordForgottenDetails;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.notification.Notifier;

@Provider
@Path("")
// @Api(value = "PasswordResetController")
public class PasswordResetController {

    @POST
    @Path("/password/reset")
    public static Response sendResetPasswordLink(
            @Context ServletContext ctx,
            @Context HttpServletRequest request,
            InputStream body) {

        try {
            RegistrationCheck.doCrawlerCheck(request.getHeader("user-agent"));

            ObjectMapper mapper = new ObjectMapper();
            PasswordForgottenDetails passwordDetails = mapper.readValue(body, PasswordForgottenDetails.class);

            Optional<User> user = UserRepository.getUser(passwordDetails.getEmail());
            int userId = user.get().getId();
            String secret = UserRepository.setPasswordResetSecret(userId);

            String georepoPlatform = ctx.getInitParameter("GEOREPO_URL_EXT");
            String resetLink = georepoPlatform + "/georepo-server/registration/password/resetform?s=" + secret
                    + "&m=" + passwordDetails.getEmail();

            Notifier.notifyPasswordResetLink(ctx, passwordDetails, resetLink);

        } catch (IOException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (InternalError | RuntimeException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path("/password/resetform")
    public static Response getResetPasswordForm(
            @Context ServletContext ctx,
            @Context HttpServletRequest request,
            @QueryParam("s") String secret,
            @QueryParam("m") String email) {

        try {
            RegistrationCheck.doCrawlerCheck(request.getHeader("user-agent"));

            // checking the secret not neccessary here,
            // will be done once it gets submitted

            String georepoPlatform = ctx.getInitParameter("GEOREPO_URL_EXT");
            String submitLink = georepoPlatform + "/georepo-server/registration/password";

            String pwResetForm = "<html><form action='" + submitLink + "' method='post'>"
                    + "<div align='center'>"
                    + "<p id='resetpwusername'>Change your password</p>"
                    + "<br>"
                    + "<table class='logintable'>"
                    + "    <tr><td><input name='resetpw' type='password'  placeholder='New password'/></td></tr>"
                    + "    <tr><td><input name='resetpwrepeat' type='password'  placeholder='Repeat new password'/></td></tr>"
                    + "    <tr><td><input name='secret' type='hidden' value='" + secret + "'/></td></tr>"
                    + "    <tr><td><input name='email' type='hidden' value='" + email + "'/></td></tr>"
                    + "</table>"
                    + "<br>"
                    + "<input type='submit' value='Reset password'>"
                    + "</div></form></html>";

            return Response.ok().entity(pwResetForm).build();

        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (InternalError | RuntimeException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path("/password")
    public static Response resetPassword(
            @Context ServletContext ctx,
            @Context HttpServletRequest request,
            @FormParam("resetpw") String resetPassword,
            @FormParam("resetpwrepeat") String resetPasswordRepeat,
            @FormParam("secret") String secret,
            @FormParam("email") String email) {

        try {
            RegistrationCheck.doCrawlerCheck(request.getHeader("user-agent"));

            // check that there is a secret provided
            if (secret == null || secret.equals("null")) {
                throw new ForbiddenException();
            }

            // check that repeated password equals new password
            if (!resetPassword.equals(resetPasswordRepeat)) {
                System.out.println("Password reset: new passwords do not equal.");
                throw new IOException("New passwords must be equal.");
            }

            // change pw in db
            UserRepository.resetPassword(resetPassword, secret, email);

            // sends mail notification about pw change
            Notifier.notifyPasswordResetSuccessful(ctx, email);

            String confirmation = "<html><center><div style='color:#224366;margin:40px'>"
                    + "Your password has been succesfully changed.</div></center></html>";
            return Response.ok().entity(confirmation).build();
        } catch (IOException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).entity(e.getCause()).build();
        } catch (NotFoundException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (ForbiddenException e) {
            e.printStackTrace();
            return Response.status(Status.FORBIDDEN).build();
        }
    }

    // private static void doCrawlerCheck(HttpServletRequest request) {
    // String userAgent = request.getHeader("user-agent").toLowerCase();
    // if (userAgent.contains("bot") || userAgent.contains("crawl")) {
    // throw new NotFoundException();
    // }
    // }
}
