package de.narimo.georepo.server.api;

import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.geometa.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.comments.CommentOrLinkService;
import de.narimo.georepo.server.api.comments.Weblink;
import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.tools.AdminTools;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{workspace}/layers/{layername}/features/{gfid}/comments")
@Tag(name = "Comments")
public class CommentController {

    CommentOrLinkService commentService = new CommentOrLinkService();

    @GET
    @Path("/")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Retrieve all comments of a feature")
    public Response getFeatureComments(
            @Context SecurityContext sec,
            @PathParam("workspace") String workspace,
            @PathParam("layername") String dataLayerName,
            @PathParam("gfid") int gfid) throws SQLException {

        try {
            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();

            int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);

            List<Weblink> comments = commentService.getComments(user, workspace, layerId, gfid);
            return Response.ok().entity(comments).build();

        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path("/{commentId}")
    @Operation(summary = "Delete a comment of a feature of a layer")
    public Response deleteFeatureComment(
            @Context SecurityContext sec,
            @PathParam("workspace") String workspace,
            @PathParam("layername") String dataLayerName,
            @PathParam("gfid") int gfid,
            @PathParam("commentId") int commentId) throws SQLException {

        User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();
        AdminTools.checkAdminPermission(user.getId(), workspace);

        int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);
        commentService.deleteCommentOrWeblink(layerId, gfid, commentId);

        return Response.status(200).build();
    }

}
