package de.narimo.georepo.server.api;

import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{diffWorkspace}/layers/{layername}/images/changes")
@Tag(name = "Images")
public class ImageLayerModificationController {

    @GET
    @Path("/")
    @Produces(MediaType.APPLICATION_JSON)
    @Operation(summary = "Retrieves all unreviewed images of a layer")
    public static Response getLayerImages(
            @Context SecurityContext sec,
            @Context ServletContext ctx,
            @PathParam("diffWorkspace") String diffWorkspace,
            @PathParam("layername") String dataLayerName) {

        return Response.status(Status.NOT_IMPLEMENTED).build();
    }

}
