package de.narimo.georepo.server.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.GeorepoFeatureType;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.commons.json.JsonConverter;
import de.narimo.georepo.server.GeorepoDatasource;
import de.narimo.georepo.server.GeorepoFeature;
import de.narimo.georepo.server.dto.FeatureType;
import de.narimo.georepo.server.geoserver.GeoserverLayer;
import de.narimo.georepo.server.geoserver.GeoserverWorkspace;
import de.narimo.georepo.server.tools.ImportTools;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{workspace}")
@Tag(name = "Imports")
public class ImportController {

//    @POST
//    @Path("/import")
//    @Operation(summary = "Upload and import a CSV file as a data layer")
//    @Consumes(MediaType.MULTIPART_FORM_DATA)
//    public static Response importFile(
//            @Context SecurityContext sec,
//            @Context ServletContext ctx,
//
//            @PathParam("workspace") String workspace,
//
//            @FormDataParam("layertitle") String layerTitle,
//            @FormDataParam("columntypes") String columnTypes,
//
//            // for upload file import
//            @FormDataParam("file") InputStream fileInputStream,
//            @FormDataParam("file") FormDataContentDisposition fileMetaData,
//
//            @FormDataParam("csvdelimiter") String usedCSVDelimiter,
//            @FormDataParam("decimalsep") String decimalSep,
//            @FormDataParam("thousandssep") String thousandsSep,
//            @FormDataParam("lonname") String optLongitudeName,
//            @FormDataParam("latname") String optLatitudeName,
//            @FormDataParam("approved") String approvedString,
//            @FormDataParam("keepRowColumnName") String keepRowColumnName,
//            @FormDataParam("keepRowColumnValue") String keepRowColumnValue) throws Exception {
//
//        if (workspace == null) {
//            throw new IOException("Workspace not defined.");
//        }
//        if (layerTitle == null) {
//            throw new IllegalArgumentException("Missing or wrong parameter layertitle.");
//        }
//        if (columnTypes == null) {
//            throw new IllegalArgumentException("Missing or wrong parameter columntypes.");
//        }
//        if (usedCSVDelimiter == null) {
//            throw new IllegalArgumentException("Missing or wrong parameter csvdelimiter.");
//        }
//        boolean approved = Boolean.parseBoolean(approvedString);
//
//        File csvFile = ImportTools.uploadFile(ctx, workspace, fileInputStream, fileMetaData);
//        ImportTools.importFile(ctx, layerTitle, columnTypes, workspace, csvFile, usedCSVDelimiter,
//                decimalSep, thousandsSep, optLongitudeName, optLatitudeName, approved, keepRowColumnName,
//                keepRowColumnValue);
//        return Response.status(201).build();
//    }

    @POST
    @Path("/import")
    @Operation(summary = "Upload and import a CSV file as a data layer")
    @Consumes({ "image/png", "image/jpg", "image/jpeg", "image/gif" })
    public static Response importFile(
            @Context SecurityContext sec,
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace,

            @QueryParam("layertitle") String layerTitle,
            @QueryParam("columntypes") String columnTypes,

            @QueryParam("csvdelimiter") String usedCSVDelimiter,
            @QueryParam("decimalsep") String decimalSep,
            @QueryParam("thousandssep") String thousandsSep,
            @QueryParam("lonname") String optLongitudeName,
            @QueryParam("latname") String optLatitudeName,
            @QueryParam("approved") String approvedString,
            @QueryParam("keepRowColumnName") String keepRowColumnName,
            @QueryParam("keepRowColumnValue") String keepRowColumnValue,

            @QueryParam("filename") String filename,
            InputStream fileInputStream) throws Exception {

        if (workspace == null) {
            throw new IOException("Workspace not defined.");
        }
        if (layerTitle == null) {
            throw new IllegalArgumentException("Missing or wrong parameter layertitle.");
        }
        if (columnTypes == null) {
            throw new IllegalArgumentException("Missing or wrong parameter columntypes.");
        }
        if (usedCSVDelimiter == null) {
            throw new IllegalArgumentException("Missing or wrong parameter csvdelimiter.");
        }
        boolean approved = Boolean.parseBoolean(approvedString);

        File csvFile = ImportTools.uploadFile(ctx, workspace, fileInputStream, filename);
        ImportTools.importFile(ctx, layerTitle, columnTypes, workspace, csvFile, usedCSVDelimiter,
                decimalSep, thousandsSep, optLongitudeName, optLatitudeName, approved, keepRowColumnName,
                keepRowColumnValue);
        return Response.status(201).build();
    }

    /**
     * Deprecated. Use LayerController.createEmptyLayer().
     * 
     * @param sec
     * @param ctx
     * @param workspace
     * @param layerTitle
     * @param headerTypes
     * @param columnTypes
     * @param layerType
     * @return
     * @throws Exception
     */
    @Deprecated
    @POST
    @Path("/import/structure")
    @Operation(summary = "Import a data structure as an empty data layer")
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    public static Response importEmptyLayer(
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace,

            @FormParam("layertitle") String layerTitle,
            @FormParam("columnheaders") String columnHeaders,
            @FormParam("columntypes") String columnTypes) throws Exception {

        if (workspace == null) {
            throw new IOException("Workspace not defined.");
        }
        if (layerTitle == null) {
            throw new IllegalArgumentException("Missing or wrong parameter layertitle.");
        }
        if (columnTypes == null) {
            throw new IllegalArgumentException("Missing or wrong parameter columntypes.");
        }

        LayerController.createEmptyLayer(ctx, workspace, layerTitle, "POINT", columnHeaders, columnTypes);
        return Response.status(201).build();
    }

    @POST
    @Path("/import/remote")
    @Operation(summary = "Import a CSV file from a remote resource as a data layer")
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    public static Response importRemoteFile(
            @Context SecurityContext sec,
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace,

            @FormParam("layertitle") String layerTitle,
            @FormParam("columntypes") String columnTypes,

            // for remote file import
            @FormParam("csvdelimiter") String usedCSVDelimiter,
            @FormParam("remotecsvurl") String remoteCSVUrl,
            @FormParam("decimalsep") String decimalSep,
            @FormParam("thousandssep") String thousandsSep,
            @FormParam("lonname") String optLongitudeName,
            @FormParam("latname") String optLatitudeName,
            @FormParam("approved") String approvedString,
            @FormParam("keepRowColumnName") String keepRowColumnName,
            @FormParam("keepRowColumnValue") String keepRowColumnValue) throws Exception {

        if (workspace == null) {
            throw new IOException("Workspace not defined.");
        }
        if (layerTitle == null) {
            throw new IllegalArgumentException("Missing or wrong parameter layertitle.");
        }
        if (columnTypes == null) {
            throw new IllegalArgumentException("Missing or wrong parameter columntypes.");
        }
        if (usedCSVDelimiter == null) {
            throw new IllegalArgumentException("Missing or wrong parameter csvdelimiter.");
        }
        if (remoteCSVUrl == null) {
            throw new IllegalArgumentException("Missing or wrong parameter remotecsvurl.");
        }
        boolean approved = Boolean.parseBoolean(approvedString);

        File csvFile = ImportTools.getRemoteCSVFile(ctx, workspace, remoteCSVUrl, approved);
        ImportTools.importFile(ctx, layerTitle, columnTypes, workspace, csvFile, usedCSVDelimiter,
                decimalSep, thousandsSep, optLongitudeName, optLatitudeName, approved, keepRowColumnName,
                keepRowColumnValue);
        return Response.status(201).build();

    }

    /**
     * Returns all feature types of a given workspace, together with additional
     * information.
     *
     * @return
     * @throws Exception
     */
    @Deprecated
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/featuretypes")
    @Operation(summary = "Deprecated. Use WFS DescribeFeature operation instead.")
    public static Response getFeatureTypes(
            @Context SecurityContext sec,
            @Context ServletContext ctx,

            @PathParam("workspace") String workspace) throws Exception {

        List<GeorepoFeatureType> featureTypes = new ArrayList<GeorepoFeatureType>();
        JDBCConnectionJNDI jdbcMeta = null;
        ResultSet rs = null;

        if (true) {
            // return empty list
            return Response.ok().entity(JsonConverter.toJson(featureTypes)).build();
        }

        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");

            GeoserverLayer layer = new GeoserverLayer(ctx);
            GeorepoFeature f = new GeorepoFeature(
                    layer.getGeoserverUrl(),
                    layer.getHeaders(),
                    layer.getGeoserverUser(),
                    layer.getGeoserverPass());

            GeoserverWorkspace wrkspc = new GeoserverWorkspace(
                    layer.getGeoserverRestUrl(),
                    layer.getHeaders(),
                    layer.getGeoserverUser(),
                    layer.getGeoserverPass());

            List<String> datasources = wrkspc.getDatasources(workspace);

            for (String d : datasources) {

                try {

                    System.out.println("\n\nDatasource: " + d);

                    List<FeatureType> ftl1 = f.getFeatureTypes(layer.getGeoserverRestUrl(), workspace, d);

                    for (FeatureType ft : ftl1) {
                        System.out.println("FeatureType: " + ft.getName());

                        String ftName = ft.getName();

                        GeorepoFeatureType featureType = new GeorepoFeatureType();
                        featureType.setName(ftName);
                        featureType.setDatasourceName(d);

                        if (!d.startsWith(GeorepoDatasource.georepoDatasourcePrefix)) {
                            throw new IllegalArgumentException("Datasource " + d + " does not contain correct prefix.");
                            // Integer layerId =
                            // Integer.valueOf(d.split(GeorepoLayer.georepoDatasourcePrefix)[1]);
                        }

                        Integer layerId = -1;
                        String[] ft_parts = ftName.split("_");
                        try {
                            layerId = Integer.valueOf(ft_parts[ft_parts.length - 1]);
                        } catch (NumberFormatException nfe) {
                            continue;
                        }

                        if (layerId < 1) {
                            continue;
                        }

                        String sql = "SELECT layer, lastupdated from datasets WHERE id=?;";
                        System.out.println(sql);

                        PreparedStatement ps = jdbcMeta.prepareStatement(sql);
                        ps.setInt(1, layerId);

                        rs = ps.executeQuery();
                        String lastUpdated = "-";
                        String layerTitle = "-";
                        if (rs.next()) {
                            layerTitle = rs.getString("layer");
                            lastUpdated = rs.getString("lastupdated");
                        }

                        featureType.setLastUpdated(lastUpdated);
                        featureType.setLayerTitle(layerTitle);
                        featureType.setLayerId(layerId);

                        featureTypes.add(featureType);
                    }

                    // }

                } catch (Exception e) {
                    System.out.println("Cannot fetch layer name for datasource " + d + " on workspace " + workspace
                            + ". Continue with next layer...");
                    e.printStackTrace();
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
                jdbcMeta = null;
            }
        }

        return Response.ok().entity(JsonConverter.toJson(featureTypes)).build();
    }
}
