package de.narimo.georepo.server.api;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import de.narimo.georepo.server.repository.DatasetRepository;

public class TagService {

    public List<String> getTags(int layerId)
            throws IOException, SQLException {

        // if no tags table exists, return empty list
        boolean tagsTableExists = DatasetRepository.checkTagTableExists(layerId);
        if (!tagsTableExists) {
            System.out.println("Tags table does not yet exist for layer " + layerId + ". No tags present.");
            return Arrays.asList();
        }

        return DatasetRepository.getTags(layerId);
    }
}
