package de.narimo.georepo.server.api;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import de.narimo.commons.dto.geometa.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.api.comments.CommentOrLinkService;
import de.narimo.georepo.server.api.comments.Weblink;
import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.repository.DifftableRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;

@Provider
@Path("/workspaces/{diffWorkspace}/layers/{layername}/links/changes")
@Tag(name = "Weblinks")
public class WeblinkLayerModificationController {

    CommentOrLinkService commentService = new CommentOrLinkService();

    @GET
    @Path("/")
    @Produces({ MediaType.APPLICATION_JSON })
    @Operation(summary = "Retrieve all suggested web links of a layer")
    public Response getSuggestedLayerWeblinks(
            @Context SecurityContext sec,
            @PathParam("diffWorkspace") String diffWorkspace,
            @PathParam("layername") String dataLayerName) throws IOException, SQLException {

        try {
            User user = UserRepository.getUser(sec.getUserPrincipal().getName()).get();

            String workspace = DifftableRepository.getDataWorkspace(diffWorkspace, dataLayerName);
            if (workspace == null) {
                throw new InternalError("No data workspace defined.");
            }

            // If user has no write permission on that workspace, he would already have been
            // thrown out by authorisation layer
            int layerId = DatasetRepository.getLayerId(workspace, dataLayerName);

            List<Weblink> weblinks = commentService.getDiffWeblinks(user, workspace, layerId);
            return Response.ok().entity(weblinks).build();

        } catch (SQLException e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}
