package de.narimo.georepo.server.api.observations;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import de.narimo.commons.dto.geometa.User;

public class ObservationsService {

    public List<Observation> getObservationsByTimeRange(int layerId, int gfid, String fromDate, String toDate)
            throws SQLException {

        boolean observationsTableExists = ObservationsRepository.checkObservationsTableExists(layerId);
        if (!observationsTableExists) {
            System.out.println(
                    "Observations table does not yet exist for layer " + layerId + ". No observations present.");
            return Arrays.asList();
        }
        return ObservationsRepository.getObservationsByTimeRange(layerId, gfid, fromDate, toDate);
    }

    public List<Observation> getObservationsByYears(int layerId, int gfid)
            throws SQLException {

        boolean observationsTableExists = ObservationsRepository.checkObservationsTableExists(layerId);
        if (!observationsTableExists) {
            System.out.println(
                    "Observations table does not yet exist for layer " + layerId + ". No observations present.");
            return Arrays.asList();
        }
        return ObservationsRepository.getObservationsByYears(layerId, gfid);
    }

    public List<Observation> getObservationsBySearchTerm(int layerId, String searchTerm)
            throws SQLException {

        boolean observationsTableExists = ObservationsRepository.checkObservationsTableExists(layerId);
        if (!observationsTableExists) {
            System.out.println(
                    "Observations table does not yet exist for layer " + layerId + ". No observations present.");
            return Arrays.asList();
        }
        return ObservationsRepository.getObservationsBySearchTerm(layerId, searchTerm);
    }

    public void addObservation(int layerId, User user, Observation observation) throws SQLException {

        boolean observationsTableExists = ObservationsRepository.checkObservationsTableExists(layerId);
        if (!observationsTableExists) {
            System.out.println("Observations table does not yet exist for layer " + layerId + ". Creating it...");
            ObservationsRepository.createObservationsTable(layerId);
        }

        ObservationsRepository.insertObservation(layerId, user.getId(), observation);
    }
}
