package de.narimo.georepo.server.geoserver;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName("settings")
@JsonInclude(Include.NON_NULL)
@JsonTypeInfo(include = As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
public class WorkspaceSettings {

    private String proxyBaseUrl;
    private String charset;
    private String onlineResource;
    private Contact contact;

    public String getProxyBaseUrl() { return proxyBaseUrl; }

    public void setProxyBaseUrl(String proxyBaseUrl) { this.proxyBaseUrl = proxyBaseUrl; }

    public String getCharset() { return charset; }

    public void setCharset(String charset) { this.charset = charset; }

    public String getOnlineResource() { return onlineResource; }

    public void setOnlineResource(String onlineResource) { this.onlineResource = onlineResource; }

    public Contact getContact() { return contact; }

    public void setContact(Contact contact) { this.contact = contact; }
}
