package de.narimo.georepo.server.tools;

import java.util.List;

import javax.ws.rs.ForbiddenException;

import de.narimo.commons.dto.geometa.User;
import de.narimo.geocore.ws.repository.UserRepository;
import de.narimo.georepo.server.repository.WorkspaceRepository;

public class AdminTools {

    /**
     * Check if user has admin permissions for the workspace.
     *
     * @throws ForbiddenException in case of missing admin permission for the
     *                            workspace
     */
    public static void checkAdminPermission(int userId, String workspace) throws ForbiddenException {
        if (!isWorkspaceAdmin(userId, workspace)) {
            throw new ForbiddenException("Unsufficient permissions for this operation.");
        }
    }

    public static boolean isWorkspaceAdmin(int userId, String workspace) throws ForbiddenException {
        int workspaceCount = WorkspaceRepository.getWorkspaceCount(userId, workspace,
                WorkspacePermissions.adminPermission);
        if (workspaceCount < 1) {
            return false;
        }
        return true;
    }

    public static void checkCanCreateWorkspace(int userId) throws ForbiddenException {
        if (!UserRepository.canUserCreateWorkspace(userId)) {
            throw new ForbiddenException("No permissions to create workspace.");
        }
    }

    /**
     * Get users with admin permission on a given workspace and enabled in users
     * table.
     * 
     * @param workspace
     * @return
     */
    public static List<User> getAdminUsers(String workspace) {
        List<Integer> adminIds = WorkspaceRepository.getWorkspaceAdminIds(workspace);
        return UserRepository.getUsersById(adminIds);
    }
}
