package de.narimo.georepo.server.tools;

import de.narimo.georepo.server.GeorepoConstants;
import de.narimo.georepo.server.GeorepoDatasource;

public class TableTools {

    public static String getDataTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId;
    }

    public static String getDiffTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + GeorepoConstants.diffTableSuffix;
    }

    public static String getDiffAuthTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + GeorepoConstants.diffAuthTableSuffix;
    }

    public static String getImageTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_img";
    }

    public static String getImageDiffTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_img_diff";
    }

    public static String getCommentTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_cmt";
    }

    public static String getCommentDiffTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_cmt_diff";
    }

    public static String getTagTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_tags";
    }

    public static String getSpeciesTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_spec";
    }

    public static String getObservationsTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_obs";
    }

    public static String getHistTableName(int layerId) {
        return GeorepoDatasource.georepoDatasourcePrefix + "" + layerId + "_hist";
    }

    public static String getDiffLayerName(String layerName) { return layerName + GeorepoConstants.diffTableSuffix; }

}
