package de.narimo.georepo.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletContext;
import javax.ws.rs.core.Response;

import de.narimo.georepo.server.dto.FeatureType;
import de.narimo.georepo.server.geoserver.GeoserverLayer;
import de.narimo.georepo.server.geoserver.GeoserverPostgisLayer;

public class GeorepoTools {

    public static Response importGeoCSV(
            ServletContext context,
            String geoserverDataDir,
            String sridAsString,
            String delimiter,
            String csvFileName,
            String readableLayerName,
            String workspace,
            String[] optColumnTypes) throws Exception {

//		String fileType = "csv";
        boolean transactionSupport = true; // allow transaction support per default

//		long userId = 3032; //should be determined by user principal
        int srid;

        // input validity checks
        if (sridAsString == null)
            sridAsString = "4326"; // default per geoCSV spec see http://giswiki.hsr.ch/GeoCSV
        if (delimiter == null)
            delimiter = ";";
        if (csvFileName == null || csvFileName.split("\\.").length > 2 || !csvFileName.endsWith(".csv"))
            throw new IllegalArgumentException("File must be of type csv."); // only .csv file type is allowed here
        if (readableLayerName == null)
            throw new IllegalArgumentException("No layer name given.");

        try {
            srid = Integer.valueOf(sridAsString);
        } catch (Exception e) {
            throw new IllegalArgumentException("Missing or wrong parameter srid. Must be numeric only.");
        }

        String toCsvFilePath = copyFileToImportDir(geoserverDataDir, workspace, csvFileName);

        String fileType = GeorepoTools.getFileExtension(toCsvFilePath);
        if (!fileType.equals("csv"))
            throw new IllegalArgumentException("Wrong file type " + fileType + ", csv expected.");

//		//TODO: the used file actually has to reside in /geoserverdatadir/data/000tmp (static in postgres function import_csv_file_to_temp_table)
//		//so we need to move file from upload dir to this import dir
//		//csvFileName must be unique, to avoid overriding by other users in common import dir!!
//		//so append millisecond timestamp to copied filename 
////		String fromCsvFilePath = ctxt.getInitParameter(geoserverDataDir)+"/data/"+String.valueOf(userId)+"/upload/"+csvFileName;
////		String fromCsvFilePath = geoserverDataDir+"/data/"+String.valueOf(userId)+"/upload/"+csvFileName;
//		
//		String fromCsvFilePath = geoserverDataDir+"/data/"+workspace+"/upload/"+csvFileName;
//		String name = csvFileName.substring(0, csvFileName.lastIndexOf("."));
//		String extension = csvFileName.substring(csvFileName.lastIndexOf("."), csvFileName.length());
//		String toFile = name+"_"+System.currentTimeMillis()+extension;
//		
////		String toCsvFilePath = ctxt.getInitParameter(geoserverDataDir)+"/data/000tmp/"+toFile;
//		String toCsvFilePath = geoserverDataDir+"/data/000tmp/"+toFile;
//		Path target = Files.copy(Paths.get(fromCsvFilePath), Paths.get(toCsvFilePath), StandardCopyOption.REPLACE_EXISTING);
//
//		System.out.println("Copied input file "+fromCsvFilePath+" to import directory: "+target);
////		String userWorkspace = "u"+String.valueOf(userId);

//        String[] columnTypes = optColumnTypes == null ? null : optColumnTypes.split("\\s*,\\s*");

        GeorepoLayer l = new GeorepoLayer();
//		l.create(toFile, fileType, readableLayerName, srid, delimiter, userWorkspace, userId, transactionSupport, ctxt.getInitParameter(geoserverDataDir));
//		l.create(context, toCsvFilePath, fileType, readableLayerName, srid, delimiter, workspace, userId, transactionSupport, geoserverDataDir);
        String featureType = l.create(context, toCsvFilePath, fileType, readableLayerName, srid, delimiter, workspace,
                transactionSupport, geoserverDataDir, null, optColumnTypes);

        Files.delete(Paths.get(toCsvFilePath)); // remove temp file from common import dir

        // currently comes back: https://213.136.80.181:8443/georepo-server/gd_46
        // should be: https://dev.georepo.com/georepo-server/u3032/wms

        return Response.created(new URI(featureType)).build();
    }

    public static Response importEmptyLayer(
            ServletContext context,
            String sridAsString,
            String readableLayerName,
            String workspace,
            String[] columnHeaders,
            String[] columnTypes) throws Exception {

        boolean transactionSupport = true; // allow transaction support per default

        if (sridAsString == null) {
            sridAsString = "4326"; // default per geoCSV spec see http://giswiki.hsr.ch/GeoCSV
        }

        int srid;
        try {
            srid = Integer.valueOf(sridAsString);
        } catch (Exception e) {
            throw new IllegalArgumentException("Missing or wrong parameter srid. Must be numeric only.");
        }

        if (readableLayerName == null)
            throw new IllegalArgumentException("No layer name given.");

        GeorepoLayer l = new GeorepoLayer();
        String featureType = l.create(context, null, null, readableLayerName, srid, null, workspace,
                transactionSupport, null, columnHeaders, columnTypes);

        return Response.created(new URI(featureType)).build();
    }

    public static Response replaceGeoCSVLayer(
            ServletContext context,
            String geoserverDataDir,
            String sridAsString,
            String delimiter,
            String csvFileName,
//			String layerTitle,
            String workspace,
            String optColumnTypes,
            int layerId) throws Exception {

        // input validity checks
        if (sridAsString == null)
            sridAsString = "4326"; // default per geoCSV spec see http://giswiki.hsr.ch/GeoCSV
        if (delimiter == null)
            delimiter = ";";
        if (csvFileName == null || csvFileName.split("\\.").length > 2 || !csvFileName.endsWith(".csv"))
            throw new IllegalArgumentException("File must be of type csv."); // only .csv file type is allowed here
//		if(layerTitle==null) throw new IllegalArgumentException("No layer name given.");

        int srid;
        try {
            srid = Integer.valueOf(sridAsString);
        } catch (Exception e) {
            throw new IllegalArgumentException("Missing or wrong parameter srid. Must be numeric only.");
        }

        String toCsvFilePath = copyFileToImportDir(geoserverDataDir, workspace, csvFileName);
        String fileType = GeorepoTools.getFileExtension(toCsvFilePath);
        if (!fileType.equals("csv"))
            throw new IllegalArgumentException("Wrong file type " + fileType + ", csv expected.");

        System.out.println("optColumnTypes: " + optColumnTypes);
        String[] columnTypes = optColumnTypes.split("\\s*,\\s*");

        String layerName = GeorepoLayer.replaceLayer(context, toCsvFilePath, srid, delimiter, columnTypes, layerId);

        // Update feature type (especially bbox)
        GeoserverPostgisLayer gsrvPgLayer = new GeoserverPostgisLayer(context);

        GeoserverLayer layer = new GeoserverLayer(context);
        GeorepoFeature f = new GeorepoFeature(
                layer.getGeoserverUrl(),
                layer.getHeaders(),
                layer.getGeoserverUser(),
                layer.getGeoserverPass());
//		String featureType = f.getFeatureType(layer.getGeoserverRestUrl(), workspace, GeorepoLayer.georepoDatasourcePrefix+layerId);
//		gsrvPgLayer.recalculateFeatureType(workspace, GeorepoLayer.georepoDatasourcePrefix+layerId, featureType);

        // NB: this introduces the convention to have a datasource named according to
        // prefix + workspace, e.g: gd_ws5111 for workspace ws5111
//		String datasource = GeorepoLayer.georepoDatasourcePrefix+workspace;
        String datasource = GeorepoDatasource.georepoDatasourcePrefix + workspace;

        List<FeatureType> featureTypes = f.getFeatureTypes(layer.getGeoserverRestUrl(), workspace, datasource);

        // NB: This is convention, to name featuretypes (==layer name) ending with _gd_
        // + layerId
//		String featureTypeId = "_"+GeorepoLayer.georepoDatasourcePrefix+layerId;
        String featureTypeId = "_" + GeorepoDatasource.georepoDatasourcePrefix + layerId;
        String featureType = null;
        for (FeatureType ft : featureTypes) {
            if (ft.getName().endsWith(featureTypeId)) {
                featureType = ft.getName();
            }
        }
        if (featureType == null)
            throw new IOException("Feature type for layerId " + layerId + " not found.");

        gsrvPgLayer.recalculateFeatureType(workspace, datasource, featureType);

        Files.delete(Paths.get(toCsvFilePath)); // remove temp file from common import dir

        // currently comes back: https://213.136.80.181:8443/georepo-server/gd_46
        // should be: https://dev.georepo.com/georepo-server/u3032/wms

        return Response.created(new URI(layerName)).build();
    }

    /**
     * @deprecated not up to date. see importGeoCSV
     * 
     * @param geoserverDataDir
     * @param sridAsString
     * @param shpFileName
     * @param readableLayerName
     * @return
     * @throws Exception
     */
    public static Response importShape(
            ServletContext context,
            String geoserverDataDir,
            String sridAsString,
            String shpFileName, // should be the name as how it lives in geoserver_data_dir
            String readableLayerName,
            String[] optColumnTypes) throws IOException

    {

        if (true) {
            throw new UnsupportedOperationException();
        }
        // TODO
        String fileType = "shp";
        boolean transactionSupport = false;

        long userId = 0; // should be determined by user principal
        int srid = -1;

        if (sridAsString == null)
            throw new IllegalArgumentException("Missing or wrong parameter srid.");
        try {
            srid = Integer.valueOf(sridAsString);
        } catch (Exception e) {
            throw new IllegalArgumentException("Missing or wrong parameter srid.");
        }

        String userWorkspace = String.valueOf(userId);

        File shpFile = new File(geoserverDataDir + "/data/" + userId + "/upload/" + shpFileName);
        GeorepoLayer l = new GeorepoLayer();
        String layerName = l.create(context, shpFile.getName(), fileType, readableLayerName, srid, null, userWorkspace,
                transactionSupport, geoserverDataDir, null, optColumnTypes);

        return Response.ok().build();
    }

    public static String copyFileToImportDir(String geoserverDataDir, String workspace, String csvFileName)
            throws IOException {

        // TODO: the used file actually has to reside in /geoserverdatadir/data/000tmp
        // (static in postgres function import_csv_file_to_temp_table)
        // so we need to move file from upload dir to this import dir
        // csvFileName must be unique, to avoid overriding by other users in common
        // import dir!!
        // so append millisecond timestamp to copied filename
//				String fromCsvFilePath = ctxt.getInitParameter(geoserverDataDir)+"/data/"+String.valueOf(userId)+"/upload/"+csvFileName;
//				String fromCsvFilePath = geoserverDataDir+"/data/"+String.valueOf(userId)+"/upload/"+csvFileName;

        String fromCsvFilePath = geoserverDataDir + "/data/" + workspace + "/upload/" + csvFileName;
        String name = csvFileName.substring(0, csvFileName.lastIndexOf("."));
        String extension = csvFileName.substring(csvFileName.lastIndexOf("."), csvFileName.length());
        String toFile = name + "_" + System.currentTimeMillis() + extension;

        String toCsvFilePath = geoserverDataDir + "/data/000tmp/" + toFile;
        Path target = Files.copy(Paths.get(fromCsvFilePath), Paths.get(toCsvFilePath),
                StandardCopyOption.REPLACE_EXISTING);

        System.out.println("Copied input file " + fromCsvFilePath + " to import directory: " + toCsvFilePath);

        File csvFile = new File(toCsvFilePath);
        csvFile.setWritable(false);
        csvFile.setExecutable(false);
        boolean permissionUpdated = csvFile.setReadable(true, false);
        System.out.println("Import file permissions updated: " + permissionUpdated);
        System.out.println("Executable: " + csvFile.canExecute());
        System.out.println("Readable: " + csvFile.canRead());
        System.out.println("Writable: " + csvFile.canWrite());

        return toCsvFilePath;
    }

    /**
     * Returns the extension of a file as after the last ".".
     * 
     * 
     * @param absFileName
     * @return
     */
    public static String getFileExtension(String absFileName) {

        return absFileName.substring(absFileName.lastIndexOf(".") + 1, absFileName.length());
    }

    /**
     * Removes special chars, retains underscore. Converts space, tab and linebreak
     * to underscore. Converts umlaute. Converts to lower case.
     * 
     * TODO: what about diacritics?
     * 
     * @param inputz
     * @return
     * @throws IOException
     */
    public static String normalize(String input) throws IOException {

        // remove all special chars;
        String changed = input;

        changed = changed.replaceAll("[.!?,/\"§$%&()=`´+~|<>*{};'#-]", "");
        changed = changed.replace(":", "_");
        changed = changed.replace(" ", "_");
        changed = changed.replace("\t", "_");
        changed = changed.replace("\n", "_");

        changed = changed.toLowerCase(Locale.ENGLISH);

        changed = changed.replace("ö", "oe");
        changed = changed.replace("ä", "ae");
        changed = changed.replace("ü", "ue");
        changed = changed.replace("ü", "ss");

        // see
        // http://stackoverflow.com/questions/3322152/is-there-a-way-to-get-rid-of-accents-and-convert-a-whole-string-to-regular-lette
        changed = Normalizer.normalize(changed, Normalizer.Form.NFD);
        changed = changed.replaceAll("[^\\p{ASCII}]", "");

        if (!isAlphaNumeric(changed))
            throw new IOException("String " + input + " could not be normalized correctly.");

        return changed;
    }

    /**
     * Checks a string for only occurrences of alphanumeric characters including
     * underscore.
     * 
     * @param s
     * @return
     */
    public static boolean isAlphaNumeric(String s) { String pattern = "^[a-zA-Z0-9_]*$"; return s.matches(pattern); }

    public static void main(String[] args) throws IOException {

        String line = "time,latitude,longitude,dep@th,mag,magType,nst,gap,dmin,rms,net,id,updated,place,type,horizontalError,depthError,magError,magNst,status,locationSource,magSource";
        String[] headers = line.split(",", -1);
        String[] newHeaders = new String[headers.length];

        System.out.println("Replacing headers:\n" + Arrays.toString(headers));
        int i = 0;
        for (String header : headers) {

            header = header.replace("@", "");
            header = header.replace(":", "_");

            header = header.replace("longitude", "lat"); // lat is the expected latitude column identifier
            header = header.replace("latitude", "lon"); // lat is the expected latitude column identifier

            newHeaders[i] = header;
            i++;
        }
        System.out.println("With:\n" + Arrays.toString(newHeaders));

        if (true)
            return;

//		List<String> columnTypes = new ArrayList<String>();
//		columnTypes.add("text");
//		columnTypes.add("text");
//		columnTypes.add("integer");
//		columnTypes.add("double precision");

//		String fromDelimiter = ",";
//		String line = "time,latitude,longitude,depth,mag,magType,nst,gap,dmin,rms,net,id,updated,place,type,horizontalError,depthError,magError,magNst,status,locationSource,magSource";
//		
//		String coltypesString = "text,double precision,double precision,double precision,double precision,text,integer,double precision,double precision,double precision,text,text,text,text,text,double precision,double precision,double precision,integer,text,text,text";
//		List<String> columnTypes = Arrays.asList(coltypesString.split("\\s*,\\s*"));
//		
//		String[] splits = line.split(fromDelimiter, -1);
//		
//		System.out.println("Header count: "+splits.length);
//		System.out.println("Coltypes count: "+columnTypes.size());
//		
//		line = "";
//		for(int j=0; j<splits.length; j++){
//			
//			System.out.println("check j="+j);
//			
//			String s = splits[j];
//			
//		
//			
//			columnTypes.get(j).equals("integer");
//		}

        if (true)
            return;

        String thousandsSep = " 	";
        if (thousandsSep != null && thousandsSep.trim().equals(""))
            thousandsSep = null;
        if (thousandsSep != null && (!thousandsSep.equals(".") || !thousandsSep.equals(",")))
            throw new IOException("Supported thousands separator for numbers is '.' or ','.");

        //////////////////////////
        if (true)
            return;

//		String sz = "�\"$%&/()=sdfawsdf鴴e'#r���";
//		System.out.println("out: "+normalize(sz));
//		
//		if(true) return;
//		String wsUrl = "http://localhost:8080/geoserver/rest/workspaces/ws5111/datastores/gd_131/featuretypes/osm hydrants europe?recalculate=nativebbox,latlonbbox";
//		wsUrl = URLEncoder.encode(wsUrl, "UTF-8");
//		
//		System.out.println("wsurl: "+wsUrl);
//		
//		if(true) return;
//		
//		String json = "{\"featureTypes\":{\"featureType\":[{\"name\":\"osm hydrants europe\","+
//			"\"href\":\"http://localhost:8080/geoserver/rest/workspaces/ws5111/datastores/gd_131/featuretypes/osm+hydrants+europe.json\"}]}}";
//			
////		String json = "{\"featureType\":[{\"name\":\"osm hydrants europe\","+
////			"\"href\":\"http://localhost:8080/geoserver/rest/workspaces/ws5111/datastores/gd_131/featuretypes/osm+hydrants+europe.json\"}]}";
//			
////		String json = "{\"name\":\"osm hydrants europe\","+
////				"\"href\":\"http://localhost:8080/geoserver/rest/workspaces/ws5111/datastores/gd_131/featuretypes/osm+hydrants+europe.json\"}";
//		
//		FeatureTypesList ft = JsonConverter.fromJson(json, FeatureTypesList.class);
//			
////		String json = "{\"a\":\"value\"}";
////		
////		Test t = fromJson(json, Test.class);
////		
////		for(FeatureTypes t : ft.featureTypes){
//			for(FeatureTypes f : ft.featureTypes){
//				for(FeatureType s : f.featureType){
//					System.out.println(s.getName());
//				}
//			}
////		}
    }

}
