package de.narimo.georepo.server.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;

import de.narimo.georepo.server.repository.DatasetRepository;
import de.narimo.georepo.server.tools.TableTools;

public class FeatureLayer {

    public static String getFeatures(int userId, String dataWorkspace, String featureType) throws IOException {
        int layerId = DatasetRepository.getLayerId(dataWorkspace, featureType);
        String tableName = TableTools.getDataTableName(layerId);

        FeatureCollection featureCollection = DatasetRepository.getDatasets(tableName, userId);

        if (featureCollection.isEmpty()) {
            Map<String, Class> propertyTypes = new HashMap<String, Class>();
            propertyTypes.put("a", String.class);

            FeatureBuilder fb = new FeatureBuilder(propertyTypes);
            featureCollection = fb.createFeatureCollection(new ArrayList<SimpleFeature>());
        }
        return FeatureBuilder.featureCollectionToJson(featureCollection);
    }
}
