package de.narimo.georepo.server.providers;

import java.io.IOException;
import java.sql.SQLException;

import de.narimo.commons.dto.geometa.User;
import de.narimo.georepo.server.repository.DifftableRepository;
import de.narimo.georepo.server.repository.WorkspaceRepository;
import de.narimo.georepo.server.tools.WorkspacePermissions;

public class WorkspaceRegistrationProvider {

    public static void addWorkspaceUser(User user, WorkspaceRegistrationDetails registrationDetails)
            throws IOException, SQLException {

        boolean workspaceSecretValid = WorkspaceRepository.isWorkspaceSecretValid(registrationDetails.getWorkspace(),
                registrationDetails.getWorkspaceSecret());

        if (!workspaceSecretValid) {
            throw new IOException("Registration for workspace failed. Invalid workspace secret.");
        }

        // Add a read-only entry to the workspaces table
        WorkspaceRepository.changeWorkspacePermission(
                user.getId(),
                registrationDetails.getWorkspace(),
                WorkspacePermissions.readPermission);

        // Optionally assign read-write permission for the diff workspace if one
        // exists
        String diffWorkspace = DifftableRepository.getDiffWorkspace(registrationDetails.getWorkspace());
        if (diffWorkspace != null & !diffWorkspace.equals(registrationDetails.getWorkspace())) {
            WorkspaceRepository.changeWorkspacePermission(
                    user.getId(),
                    diffWorkspace,
                    WorkspacePermissions.writePermission);
        }
    }

    public static boolean isRegisteredOnWorkspace(User user, String workspace) {

        String permissionType = WorkspaceRepository.getWorkspacePermissionType(user.getId(), workspace);

        if (WorkspacePermissions.readPermission.contentEquals(permissionType) ||
                WorkspacePermissions.writePermission.contentEquals(permissionType) ||
                WorkspacePermissions.adminPermission.contentEquals(permissionType)) {
            return true;
        }
        return false;
    }
}
