package de.narimo.georepo.server.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.georepo.server.GeorepoConstants;

public class ParentDatasetRepository {

    static Map<String, String> getColumnTypes(String tableName, String schemaName) {
        JDBCConnectionJNDI jdbcData = null;

        try {
            jdbcData = new JDBCConnectionJNDI("jdbc/georepoDataResource");

            String sql0 = "SELECT column_name, data_type FROM information_schema.columns " + "WHERE table_schema = ? "
                    + "AND table_name   = ?;";

            PreparedStatement ps0 = jdbcData.prepareStatement(sql0);
            ps0.setString(1, schemaName);
            ps0.setString(2, tableName);

            List<String> reservedColumnNames = new ArrayList<>();
            reservedColumnNames.add(GeorepoConstants.GRPFIDCOLUMN);
            // reservedColumnNames.add(GeorepoConstants.GFIDCOLUMN);
            reservedColumnNames.add(GeorepoConstants.GEOMETRYCOLUMN);
            reservedColumnNames.add(GeorepoConstants.GRPSTATUSCOLUMN);

            Map<String, String> columnNames = new HashMap<>();

            ResultSet rs0 = ps0.executeQuery();
            while (rs0.next()) {
                String columnName = rs0.getString("column_name");
                if (!reservedColumnNames.contains(columnName)) {
                    columnNames.put(columnName, rs0.getString("data_type"));
                }
            }
            return columnNames;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (jdbcData != null) {
                jdbcData.closeAll();
                jdbcData = null;
            }
        }
        return null;
    }
}
